---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


ALTER TABLE question
MODIFY DISPLAYED_ANSWERS number(3,0);

ALTER TABLE question
MODIFY MAX_ANSWERS number(3,0);

INSERT INTO question(QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 142, 1, 'C', 'List the registration number of the specific cell line(s) from the stem cell registry found at: http://stemcells.nih.gov/registry/index.asp', 'A', 4, 5, null, null, 20, 200, 4, SYSDATE, 'admin', 1, SYS_GUID(), null);

INSERT INTO question(QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 145, 1, 'C', 'Will vertebrate animals be used in this project?', 'A', 2, 1, null, null, null, 1, 1, SYSDATE, 'admin', 1, SYS_GUID(), null);

INSERT INTO question(QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 146, 1, 'C', 'Are vertebrate animals euthanized?', 'A', 2, 1, null, null, null, 1, 1, SYSDATE, 'admin', 1, SYS_GUID(), null);

INSERT INTO question(QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 147, 1, 'C', 'Is method consistent with American Veterinary Medical Association (AVMA) guidelines?', 'A', 2, 1, null, null, null, 1, 1, SYSDATE, 'admin', 1, SYS_GUID(), null);

INSERT INTO question(QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 148, 1, 'C', 'If NO to AVMA Guidelines, describe method and provide scientific justification in 1000 characters or less.', 'A', 2, 5, null, null, null, 1, 1000, SYSDATE, 'admin', 1, SYS_GUID(), null);

INSERT INTO questionnaire(QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, DOCUMENT_NUMBER, VER_NBR, OBJ_ID, file_name, template)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, -1, 1, 'PHS 398 Cover Page Supplement v3-0', 'The responses are used to populate the PHS 398 Cover Page Supplement v3-0 for submission via Grants.gov.', SYSDATE, 'admin', 'Y', null, 1, SYS_GUID(), null, null);

-- 2, 3, 145, 146, 147, 148, 5, 6, 142, 118, 119, 120, 114, 115, 116, 117

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 2 AND SEQUENCE_NUMBER = 1), 1, 0, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 3 AND SEQUENCE_NUMBER = 1), 2, 1, 'Y', 3, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 145 AND SEQUENCE_NUMBER = 1), 3, 2, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 146 AND SEQUENCE_NUMBER = 1), 4, 3, 'Y', '4', 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 147 AND SEQUENCE_NUMBER = 1), 5, 4, 'Y', '4', 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 148 AND SEQUENCE_NUMBER = 1), 6, 5, 'Y', '4', 'N', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 5 AND SEQUENCE_NUMBER = 1), 7, 2, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 6 AND SEQUENCE_NUMBER = 1), 8, 7, 'Y', 4, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 142 AND SEQUENCE_NUMBER = 1), 9, 7, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 118 AND SEQUENCE_NUMBER = 1), 10, 9, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 119 AND SEQUENCE_NUMBER = 1), 11, 10, 'Y', 4, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 120 AND SEQUENCE_NUMBER = 1), 12, 11, 'Y', 4, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 114 AND SEQUENCE_NUMBER = 1), 13, 12, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 115 AND SEQUENCE_NUMBER = 1), 14, 13, 'Y', 4, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 116 AND SEQUENCE_NUMBER = 1), 15, 14, 'N', null, null, SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

INSERT INTO questionnaire_questions(QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 117 AND SEQUENCE_NUMBER = 1), 16, 15, 'Y', 4, 'Y', SYSDATE, 'admin', 1, 1, SYS_GUID(), null);

Insert into QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID,MODULE_ITEM_CODE,MODULE_SUB_ITEM_CODE,QUESTIONNAIRE_REF_ID_FK,QUESTIONNAIRE_SEQUENCE_NUMBER,RULE_ID,QUESTIONNAIRE_LABEL,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,IS_MANDATORY)
values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -1 AND SEQUENCE_NUMBER = 1), 1,null,'PHS 398 Cover Page Supplement v3-0',SYSDATE,'admin',1,SYS_GUID(),'N');

insert into s2s_form_to_questionnaire (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 'http://apply.grants.gov/forms/PHS398_CoverPageSupplement_3_0-V3.0', 'PHS398_CoverPageSupplement_3_0-V3.0', -1, SYSDATE, 'admin', SYS_GUID(), '1');
