---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE TABLE SUBAWARD_MODIFICATION_TYPE (
  CODE varchar2(30) NOT NULL PRIMARY KEY,
  DESCRIPTION varchar2(2000) NOT NULL,
  ACTIVE CHAR(1) DEFAULT 'Y' NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  VER_NBR NUMBER (8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);
  
alter table SUBAWARD_AMOUNT_INFO add MODIFICATION_TYPE_CODE varchar2(30);
alter table SUBAWARD_AMOUNT_INFO add constraint FK3_SUBAWARD_AMOUNT_INFO foreign key (MODIFICATION_TYPE_CODE)
    REFERENCES SUBAWARD_MODIFICATION_TYPE (CODE);
    
insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1000', 'No Cost Extension', 'Y', 'admin', sysdate, 1, SYS_GUID());
	
insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1001', 'Increment', 'Y', 'admin', sysdate, 1, SYS_GUID());

insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1002', 'Continuation of Other', 'Y', 'admin', sysdate, 1, SYS_GUID());


	
