---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
-- question type decimal
insert into question_types (QUESTION_TYPE_ID, QUESTION_TYPE_NAME, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID) values (7, 'Decimal', sysdate, 'admin', 1, SYS_GUID());

-- questionnaire
Insert into QUESTIONNAIRE (QUESTIONNAIRE_REF_ID,QUESTIONNAIRE_ID,SEQUENCE_NUMBER,NAME,DESCRIPTION,UPDATE_TIMESTAMP,UPDATE_USER,IS_FINAL,VER_NBR,OBJ_ID,FILE_NAME) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,SEQ_QUESTIONNAIRE_ID.NEXTVAL,1,'Supplementary Cover Sheet for NEH Grant Programs','These questions support Supplementary Cover Sheet for NEH Grant Programs Grants.gov forms.',sysdate, 'admin','Y',1,SYS_GUID(),null);


-- Major Field of Study question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,300,1,'C','The Project Director''s Major Field of Study is?','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','FieldOfStudy',null,1,100,sysdate, 'admin',1,SYS_GUID(),null);


INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'The Project Director''s Major Field of Study is?' AND SEQUENCE_NUMBER = 1),1,0,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- institution question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,301,1,'C','This Institution is considered?','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','InstitutionType',null,1,100,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'This Institution is considered?' AND SEQUENCE_NUMBER = 1),2,1,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- Federal Match question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,302,1,'C','What is the Federal Match on this project?','A',2,7,null,null,null,1,10,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'What is the Federal Match on this project?' AND SEQUENCE_NUMBER = 1),3,2,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- another NEH division question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,303,1,'C','Will this proposal be submitted to another NEH division, government agency, or private entity for funding?','A',2,1,null,null,null,1,1,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Will this proposal be submitted to another NEH division, government agency, or private entity for funding?' AND SEQUENCE_NUMBER = 1),4,3,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- another NEH division explanation question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,304,1,'C','Please explain where and when','A',2,5,null,null,null,1,50,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Please explain where and when' AND SEQUENCE_NUMBER = 1),5,4,1,'Y','4','Y','admin',sysdate,SYS_GUID(),1);

-- supplemental funding question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,305,1,'C','Is this application for supplemental funding?','A',2,1,null,null,null,1,1,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Is this application for supplemental funding?' AND SEQUENCE_NUMBER = 1),6,4,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- primary project discipline question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,306,1,'C','Please select a primary project discipline','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','ProjectDiscipline',null,1,100,sysdate, 'admin',1,SYS_GUID(),null);


INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Please select a primary project discipline' AND SEQUENCE_NUMBER = 1),7,6,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- secondary project discipline exists question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,307,1,'C','Is there a secondary project discipline?','A',2,1,null,null,null,1,1,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Is there a secondary project discipline?' AND SEQUENCE_NUMBER = 1),8,7,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- secondary project discipline question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,308,1,'C','Please select a secondary discipline','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','ProjectDiscipline',null,1,100,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Please select a secondary discipline' AND SEQUENCE_NUMBER = 1),9,8,1,'Y','4','Y','admin',sysdate,SYS_GUID(),1);

-- tertiary project discipline exists question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,309,1,'C','Is there a tertiary project discipline?','A',2,1,null,null,null,1,1,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Is there a tertiary project discipline?' AND SEQUENCE_NUMBER = 1),10,7,1,'N',null,null,'admin',sysdate,SYS_GUID(),1);

-- tertiary project discipline question
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,310,1,'C','Please select a tertiary discipline','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','ProjectDiscipline',null,1,100,sysdate, 'admin',1,SYS_GUID(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION = 'Please select a tertiary discipline' AND SEQUENCE_NUMBER = 1),11,10,1,'Y','4','Y','admin',sysdate,SYS_GUID(),1);

-- usage
Insert into QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID,MODULE_ITEM_CODE,MODULE_SUB_ITEM_CODE,QUESTIONNAIRE_REF_ID_FK,QUESTIONNAIRE_SEQUENCE_NUMBER,RULE_ID,QUESTIONNAIRE_LABEL,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,IS_MANDATORY)
values (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL ,3,(SELECT SUB_MODULE_CODE FROM COEUS_SUB_MODULE WHERE DESCRIPTION = 'S2S Questionnaires'),
																													(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'Supplementary Cover Sheet for NEH Grant Programs' AND SEQUENCE_NUMBER = 1),
																													1,null,'Supplementary Cover Sheet for NEH Grant Programs',sysdate,'admin',1,SYS_GUID(),'N');

insert into s2s_form_to_questionnaire
(S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 'http://apply.grants.gov/forms/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0', 'SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0', (select questionnaire_id from questionnaire where name='Supplementary Cover Sheet for NEH Grant Programs'), sysdate, 'admin', SYS_GUID(), '1');

-- arg values
insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-102, 'FieldOfStudy','117','Arts: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-103, 'FieldOfStudy','142','Arts: Architecture','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-104, 'FieldOfStudy','110','Arts: Art History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-105, 'FieldOfStudy','112','Arts: Dance History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-106, 'FieldOfStudy','113','Arts: Film History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-107, 'FieldOfStudy','2868','Arts: History, Criticism, and Theory of the Arts','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-108, 'FieldOfStudy','114','Arts: Music History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-109, 'FieldOfStudy','111','Arts: Theater History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-110, 'FieldOfStudy','2869','Arts: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-111, 'FieldOfStudy','124','Communications: Communications','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-112, 'FieldOfStudy','123','Communications: Composition and Rhetoric','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-113, 'FieldOfStudy','126','Communications: Journalism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-114, 'FieldOfStudy','1245','History: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-115, 'FieldOfStudy','2836','History: African American History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-116, 'FieldOfStudy','1246','History: African History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-117, 'FieldOfStudy','13','History: Ancient History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-118, 'FieldOfStudy','1247','History: British History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-119, 'FieldOfStudy','6','History: Classical History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-120, 'FieldOfStudy','2837','History: Cultural History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-121, 'FieldOfStudy','2838','History: Diplomatic History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-122, 'FieldOfStudy','8','History: East Asian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-123, 'FieldOfStudy','2839','History: Economic History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-124, 'FieldOfStudy','7','History: European History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-125, 'FieldOfStudy','2835','History: History of Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-126, 'FieldOfStudy','2840','History: Immigration History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-127, 'FieldOfStudy','2841','History: Intellectual History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-128, 'FieldOfStudy','2842','History: Labor History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-129, 'FieldOfStudy','9','History: Latin American History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-130, 'FieldOfStudy','2843','History: Latino History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-131, 'FieldOfStudy','2833','History: Medieval History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-132, 'FieldOfStudy','2844','History: Military History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-133, 'FieldOfStudy','10','History: Near and Middle Eastern History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-134, 'FieldOfStudy','2845','History: Political History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-135, 'FieldOfStudy','2846','History: Public History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-136, 'FieldOfStudy','2834','History: Renaissance History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-137, 'FieldOfStudy','11','History: Russian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-138, 'FieldOfStudy','12','History: South Asian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-139, 'FieldOfStudy','12','History: U.S. History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-140, 'FieldOfStudy','2847','History: Urban History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-141, 'FieldOfStudy','2848','History: Women''s History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-142, 'FieldOfStudy','2849','History: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-143, 'FieldOfStudy','140','Interdisciplinary: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-144, 'FieldOfStudy','104','Interdisciplinary: African American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-145, 'FieldOfStudy','89','Interdisciplinary: African Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-146, 'FieldOfStudy','76','Interdisciplinary: American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-147, 'FieldOfStudy','88','Interdisciplinary: Area Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-148, 'FieldOfStudy','105','Interdisciplinary: Asian American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-149, 'FieldOfStudy','80','Interdisciplinary: Classics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-150, 'FieldOfStudy','2859','Interdisciplinary: East Asian Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-151, 'FieldOfStudy','101','Interdisciplinary: Ethnic Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-152, 'FieldOfStudy','129','Interdisciplinary: Folklore and Folklife','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-153, 'FieldOfStudy','74','Interdisciplinary: Gender Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-154, 'FieldOfStudy','103','Interdisciplinary: Hispanic American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-155, 'FieldOfStudy','83','Interdisciplinary: History and Philosophy of Science, Technology, and Medicine','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-156, 'FieldOfStudy','87','Interdisciplinary: International Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-157, 'FieldOfStudy','106','Interdisciplinary: Jewish Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-158, 'FieldOfStudy','77','Interdisciplinary: Labor Relations','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-159, 'FieldOfStudy','90','Interdisciplinary: Latin American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-160, 'FieldOfStudy','125','Interdisciplinary: Media Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-161, 'FieldOfStudy','81','Interdisciplinary: Medieval Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-162, 'FieldOfStudy','102','Interdisciplinary: Native American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-163, 'FieldOfStudy','82','Interdisciplinary: Renaissance Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-164, 'FieldOfStudy','85','Interdisciplinary: Rural Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-165, 'FieldOfStudy','2860','Interdisciplinary: South Asian Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-166, 'FieldOfStudy','79','Interdisciplinary: Turkish Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-167, 'FieldOfStudy','86','Interdisciplinary: U.S. Regional Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-168, 'FieldOfStudy','75','Interdisciplinary: Urban Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-169, 'FieldOfStudy','84','Interdisciplinary: Western Civilization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-170, 'FieldOfStudy','2861','Interdisciplinary: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-171, 'FieldOfStudy','27','Languages: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-172, 'FieldOfStudy','38','Languages: Ancient Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-173, 'FieldOfStudy','2851','Languages: Arabic Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-174, 'FieldOfStudy','36','Languages: Asian Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-175, 'FieldOfStudy','28','Languages: Classical Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-176, 'FieldOfStudy','35','Languages: Comparative Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-177, 'FieldOfStudy','2852','Languages: Computational Linguistics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-178, 'FieldOfStudy','40','Languages: English','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-179, 'FieldOfStudy','29','Languages: French Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-180, 'FieldOfStudy','30','Languages: German Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-181, 'FieldOfStudy','31','Languages: Italian Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-182, 'FieldOfStudy','32','Languages: Latin American Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-183, 'FieldOfStudy','99','Languages: Linguistics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-184, 'FieldOfStudy','37','Languages: Near and Middle Eastern Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-185, 'FieldOfStudy','39','Languages: Romance Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-186, 'FieldOfStudy','33','Languages: Slavic Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-187, 'FieldOfStudy','34','Languages: Spanish Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-188, 'FieldOfStudy','2853','Languages: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-189, 'FieldOfStudy','127','Law: Law and Jurisprudence','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-190, 'FieldOfStudy','2870','Law: Legal History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-191, 'FieldOfStudy','42','Literature: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-192, 'FieldOfStudy','61','Literature: African Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-193, 'FieldOfStudy','55','Literature: American Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-194, 'FieldOfStudy','53','Literature: Ancient Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-195, 'FieldOfStudy','57','Literature: Arabic Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-196, 'FieldOfStudy','54','Literature: British Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-197, 'FieldOfStudy','43','Literature: Classical Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-198, 'FieldOfStudy','50','Literature: Comparative Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-199, 'FieldOfStudy','2854','Literature: East Asian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-200, 'FieldOfStudy','44','Literature: French Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-201, 'FieldOfStudy','45','Literature: German Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-202, 'FieldOfStudy','46','Literature: Italian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-203, 'FieldOfStudy','47','Literature: Latin American Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-204, 'FieldOfStudy','59','Literature: Literary Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-205, 'FieldOfStudy','52','Literature: Near and Middle Eastern Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-206, 'FieldOfStudy','56','Literature: Russian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-207, 'FieldOfStudy','48','Literature: Slavic Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-208, 'FieldOfStudy','2855','Literature: South Asian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-209, 'FieldOfStudy','49','Literature: Spanish Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-210, 'FieldOfStudy','60','Literature: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-211, 'FieldOfStudy','15','Philosophy: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-212, 'FieldOfStudy','16','Philosophy: Aesthetics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-213, 'FieldOfStudy','1248','Philosophy: Epistemology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-214, 'FieldOfStudy','1249','Philosophy: Ethics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-215, 'FieldOfStudy','19','Philosophy: History of Philosophy','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-216, 'FieldOfStudy','20','Philosophy: Logic','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-217, 'FieldOfStudy','21','Philosophy: Metaphysics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-218, 'FieldOfStudy','22','Philosophy: Non-Western Philosophy','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-219, 'FieldOfStudy','24','Philosophy: Phenomenology - Existentialism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-220, 'FieldOfStudy','23','Philosophy: Philosophy of Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-221, 'FieldOfStudy','65','Philosophy: Philosophy of Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-222, 'FieldOfStudy','25','Philosophy: Philosophy of Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-223, 'FieldOfStudy','2850','Philosophy: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-224, 'FieldOfStudy','69','Politics: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-225, 'FieldOfStudy','70','Politics: American Government','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-226, 'FieldOfStudy','2856','Politics: Comparative Politics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-227, 'FieldOfStudy','71','Politics: International Relations','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-228, 'FieldOfStudy','2857','Politics: Political Theory','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-229, 'FieldOfStudy','2858','Politics: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-230, 'FieldOfStudy','63','Religion: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-231, 'FieldOfStudy','67','Religion: Comparative Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-232, 'FieldOfStudy','64','Religion: History of Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-233, 'FieldOfStudy','66','Religion: Nonwestern Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-234, 'FieldOfStudy','2882','Religion: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-235, 'FieldOfStudy','141','Social Science: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-236, 'FieldOfStudy','108','Social Science: Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-237, 'FieldOfStudy','145','Social Science: Archaeology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-238, 'FieldOfStudy','2863','Social Science: Biological Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-239, 'FieldOfStudy','2862','Social Science: Cultural Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-240, 'FieldOfStudy','119','Social Science: Economics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-241, 'FieldOfStudy','2865','Social Science: Ethnomusicology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-242, 'FieldOfStudy','146','Social Science: Geography','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-243, 'FieldOfStudy','2864','Social Science: Linguistic Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-244, 'FieldOfStudy','144','Social Science: Psychology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-245, 'FieldOfStudy','130','Social Science: Sociology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-246, 'FieldOfStudy','2866','Social Science: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-247, 'FieldOfStudy','96','Other: Archival Management and Conservation','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-248, 'FieldOfStudy','120','Other: Business','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-249, 'FieldOfStudy','2832','Other: Computer Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-250, 'FieldOfStudy','2871','Other: Conservation Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-251, 'FieldOfStudy','2872','Other: Digital Humanities','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-252, 'FieldOfStudy','2873','Other: Digital Preservation','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-253, 'FieldOfStudy','92','Other: Education','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-254, 'FieldOfStudy','2874','Other: Engineering','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-255, 'FieldOfStudy','2875','Other: Filmmaking','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-256, 'FieldOfStudy','2876','Other: Health Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-257, 'FieldOfStudy','2877','Other: Information Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-258, 'FieldOfStudy','94','Other: Library Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-259, 'FieldOfStudy','2878','Other: Mathematics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-260, 'FieldOfStudy','97','Other: Museum Studies or Historical Preservation','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-261, 'FieldOfStudy','132','Other: Natural Sciences','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-262, 'FieldOfStudy','72','Other: Public Administration','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-263, 'FieldOfStudy','2880','Other: Radio Production','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-264, 'FieldOfStudy','2881','Other: Statistics','admin',sysdate,SYS_GUID());


insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-265, 'InstitutionType','1326: Center For Advanced Study/Research Institute','1326: Center For Advanced Study/Research Institute','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-266, 'InstitutionType','1327: Publishing','1327: Publishing','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-267, 'InstitutionType','1329: Four-Year College','1329: Four-Year College','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-268, 'InstitutionType','1330: University','1330: University','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-269, 'InstitutionType','1331: Professional School','1331: Professional School','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-270, 'InstitutionType','1332: Elementary/Middle School','1332: Elementary/Middle School','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-271, 'InstitutionType','1333: Secondary School','1333: Secondary School','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-272, 'InstitutionType','1334: School District','1334: School District','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-273, 'InstitutionType','1335: State Department of Education','1335: State Department of Education','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-274, 'InstitutionType','1336: Non-Profit Educational Center','1336: Non-Profit Educational Center','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-275, 'InstitutionType','1337: Educational Consortium','1337: Educational Consortium','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-276, 'InstitutionType','1338: Philanthropic Foundation','1338: Philanthropic Foundation','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-277, 'InstitutionType','1339: State/Local/Federal Government','1339: State/Local/Federal Government','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-278, 'InstitutionType','1340: Historical Society','1340: Historical Society','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-279, 'InstitutionType','1341: Archives','1341: Archives','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-280, 'InstitutionType','1342: Historical Site/House','1342: Historical Site/House','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-281, 'InstitutionType','1343: Historic Preservation Organization','1343: Historic Preservation Organization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-282, 'InstitutionType','1344: Public Library','1344: Public Library','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-283, 'InstitutionType','1345: Academic Library','1345: Academic Library','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-284, 'InstitutionType','1346: Independent Research Library','1346: Independent Research Library','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-285, 'InstitutionType','1347: History Museum','1347: History Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-286, 'InstitutionType','1348: Natural History Museum','1348: Natural History Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-287, 'InstitutionType','1349: Art Museum','1349: Art Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-288, 'InstitutionType','1350: University Museum','1350: University Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-289, 'InstitutionType','1351: Anthropology/Archaeology Museum','1351: Anthropology/Archaeology Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-290, 'InstitutionType','1352: Science and Technology Museum','1352: Science and Technology Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-291, 'InstitutionType','1353: General Museum','1353: General Museum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-292, 'InstitutionType','1354: Nature Center/Botanical Garden/Arboretum','1354: Nature Center/Botanical Garden/Arboretum','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-293, 'InstitutionType','1355: National Organization','1355: National Organization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-294, 'InstitutionType','1356: State Humanities Council','1356: State Humanities Council','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-295, 'InstitutionType','1357: Community-Level Organization','1357: Community-Level Organization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-296, 'InstitutionType','1358: Indian Tribal Organization','1358: Indian Tribal Organization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-297, 'InstitutionType','1359: Professional Association','1359: Professional Association','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-298, 'InstitutionType','1360: Arts Related Organizations','1360: Arts Related Organizations','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-299, 'InstitutionType','1361: Television/Station','1361: Television/Station','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-300, 'InstitutionType','1362: Radio Station','1362: Radio Station','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-301, 'InstitutionType','1363: Independent Production Company','1363: Independent Production Company','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-302, 'InstitutionType','1364: Press','1364: Press','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-303, 'InstitutionType','2786: Museums','2786: Museums','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-304, 'InstitutionType','2787: Libraries','2787: Libraries','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-305, 'InstitutionType','2819: Unknown','2819: Unknown','admin',sysdate,SYS_GUID());


insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-306, 'ProjectDiscipline','117','Arts: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-307, 'ProjectDiscipline','142','Arts: Architecture','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-308, 'ProjectDiscipline','110','Arts: Art History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-309, 'ProjectDiscipline','112','Arts: Dance History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-310, 'ProjectDiscipline','113','Arts: Film History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-311, 'ProjectDiscipline','2868','Arts: History, Criticism, and Theory of the Arts','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-312, 'ProjectDiscipline','114','Arts: Music History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-313, 'ProjectDiscipline','111','Arts: Theater History and Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-314, 'ProjectDiscipline','2869','Arts: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-315, 'ProjectDiscipline','124','Communications: Communications','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-316, 'ProjectDiscipline','123','Communications: Composition and Rhetoric','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-317, 'ProjectDiscipline','126','Communications: Journalism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-318, 'ProjectDiscipline','1245','History: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-319, 'ProjectDiscipline','2836','History: African American History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-320, 'ProjectDiscipline','1246','History: African History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-321, 'ProjectDiscipline','13','History: Ancient History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-322, 'ProjectDiscipline','1247','History: British History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-323, 'ProjectDiscipline','6','History: Classical History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-324, 'ProjectDiscipline','2837','History: Cultural History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-325, 'ProjectDiscipline','2838','History: Diplomatic History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-326, 'ProjectDiscipline','8','History: East Asian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-327, 'ProjectDiscipline','2839','History: Economic History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-328, 'ProjectDiscipline','7','History: European History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-329, 'ProjectDiscipline','2835','History: History of Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-330, 'ProjectDiscipline','2840','History: Immigration History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-331, 'ProjectDiscipline','2841','History: Intellectual History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-332, 'ProjectDiscipline','2842','History: Labor History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-333, 'ProjectDiscipline','9','History: Latin American History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-334, 'ProjectDiscipline','2843','History: Latino History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-335, 'ProjectDiscipline','2833','History: Medieval History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-336, 'ProjectDiscipline','2844','History: Military History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-337, 'ProjectDiscipline','10','History: Near and Middle Eastern History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-338, 'ProjectDiscipline','2845','History: Political History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-339, 'ProjectDiscipline','2846','History: Public History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-340, 'ProjectDiscipline','2834','History: Renaissance History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-341, 'ProjectDiscipline','11','History: Russian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-342, 'ProjectDiscipline','12','History: South Asian History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-343, 'ProjectDiscipline','12','History: U.S. History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-344, 'ProjectDiscipline','2847','History: Urban History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-345, 'ProjectDiscipline','2848','History: Women''s History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-346, 'ProjectDiscipline','2849','History: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-347, 'ProjectDiscipline','140','Interdisciplinary: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-348, 'ProjectDiscipline','104','Interdisciplinary: African American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-349, 'ProjectDiscipline','89','Interdisciplinary: African Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-350, 'ProjectDiscipline','76','Interdisciplinary: American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-351, 'ProjectDiscipline','88','Interdisciplinary: Area Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-352, 'ProjectDiscipline','105','Interdisciplinary: Asian American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-353, 'ProjectDiscipline','80','Interdisciplinary: Classics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-354, 'ProjectDiscipline','2859','Interdisciplinary: East Asian Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-355, 'ProjectDiscipline','101','Interdisciplinary: Ethnic Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-356, 'ProjectDiscipline','129','Interdisciplinary: Folklore and Folklife','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-357, 'ProjectDiscipline','74','Interdisciplinary: Gender Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-358, 'ProjectDiscipline','103','Interdisciplinary: Hispanic American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-359, 'ProjectDiscipline','83','Interdisciplinary: History and Philosophy of Science, Technology, and Medicine','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-360, 'ProjectDiscipline','87','Interdisciplinary: International Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-361, 'ProjectDiscipline','106','Interdisciplinary: Jewish Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-362, 'ProjectDiscipline','77','Interdisciplinary: Labor Relations','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-363, 'ProjectDiscipline','90','Interdisciplinary: Latin American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-364, 'ProjectDiscipline','125','Interdisciplinary: Media Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-365, 'ProjectDiscipline','81','Interdisciplinary: Medieval Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-366, 'ProjectDiscipline','102','Interdisciplinary: Native American Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-367, 'ProjectDiscipline','82','Interdisciplinary: Renaissance Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-368, 'ProjectDiscipline','85','Interdisciplinary: Rural Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-369, 'ProjectDiscipline','2860','Interdisciplinary: South Asian Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-370, 'ProjectDiscipline','79','Interdisciplinary: Turkish Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-371, 'ProjectDiscipline','86','Interdisciplinary: U.S. Regional Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-372, 'ProjectDiscipline','75','Interdisciplinary: Urban Studies','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-373, 'ProjectDiscipline','84','Interdisciplinary: Western Civilization','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-374, 'ProjectDiscipline','2861','Interdisciplinary: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-375, 'ProjectDiscipline','27','Languages: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-376, 'ProjectDiscipline','38','Languages: Ancient Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-377, 'ProjectDiscipline','2851','Languages: Arabic Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-378, 'ProjectDiscipline','36','Languages: Asian Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-379, 'ProjectDiscipline','28','Languages: Classical Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-380, 'ProjectDiscipline','35','Languages: Comparative Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-381, 'ProjectDiscipline','2852','Languages: Computational Linguistics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-382, 'ProjectDiscipline','40','Languages: English','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-383, 'ProjectDiscipline','29','Languages: French Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-384, 'ProjectDiscipline','30','Languages: German Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-385, 'ProjectDiscipline','31','Languages: Italian Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-386, 'ProjectDiscipline','32','Languages: Latin American Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-387, 'ProjectDiscipline','99','Languages: Linguistics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-388, 'ProjectDiscipline','37','Languages: Near and Middle Eastern Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-389, 'ProjectDiscipline','39','Languages: Romance Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-390, 'ProjectDiscipline','33','Languages: Slavic Languages','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-391, 'ProjectDiscipline','34','Languages: Spanish Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-392, 'ProjectDiscipline','2853','Languages: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-393, 'ProjectDiscipline','127','Law: Law and Jurisprudence','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-394, 'ProjectDiscipline','2870','Law: Legal History','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-395, 'ProjectDiscipline','42','Literature: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-396, 'ProjectDiscipline','61','Literature: African Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-397, 'ProjectDiscipline','55','Literature: American Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-398, 'ProjectDiscipline','53','Literature: Ancient Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-399, 'ProjectDiscipline','57','Literature: Arabic Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-400, 'ProjectDiscipline','54','Literature: British Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-401, 'ProjectDiscipline','43','Literature: Classical Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-402, 'ProjectDiscipline','50','Literature: Comparative Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-403, 'ProjectDiscipline','2854','Literature: East Asian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-404, 'ProjectDiscipline','44','Literature: French Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-405, 'ProjectDiscipline','45','Literature: German Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-406, 'ProjectDiscipline','46','Literature: Italian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-407, 'ProjectDiscipline','47','Literature: Latin American Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-408, 'ProjectDiscipline','59','Literature: Literary Criticism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-409, 'ProjectDiscipline','52','Literature: Near and Middle Eastern Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-410, 'ProjectDiscipline','56','Literature: Russian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-411, 'ProjectDiscipline','48','Literature: Slavic Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-412, 'ProjectDiscipline','2855','Literature: South Asian Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-413, 'ProjectDiscipline','49','Literature: Spanish Literature','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-414, 'ProjectDiscipline','60','Literature: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-415, 'ProjectDiscipline','15','Philosophy: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-416, 'ProjectDiscipline','16','Philosophy: Aesthetics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-417, 'ProjectDiscipline','1248','Philosophy: Epistemology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-418, 'ProjectDiscipline','1249','Philosophy: Ethics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-419, 'ProjectDiscipline','19','Philosophy: History of Philosophy','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-420, 'ProjectDiscipline','20','Philosophy: Logic','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-421, 'ProjectDiscipline','21','Philosophy: Metaphysics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-422, 'ProjectDiscipline','22','Philosophy: Non-Western Philosophy','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-423, 'ProjectDiscipline','24','Philosophy: Phenomenology - Existentialism','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-424, 'ProjectDiscipline','23','Philosophy: Philosophy of Language','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-425, 'ProjectDiscipline','65','Philosophy: Philosophy of Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-426, 'ProjectDiscipline','25','Philosophy: Philosophy of Science','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-427, 'ProjectDiscipline','2850','Philosophy: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-428, 'ProjectDiscipline','69','Politics: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-429, 'ProjectDiscipline','70','Politics: American Government','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-430, 'ProjectDiscipline','2856','Politics: Comparative Politics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-431, 'ProjectDiscipline','71','Politics: International Relations','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-432, 'ProjectDiscipline','2857','Politics: Political Theory','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-433, 'ProjectDiscipline','2858','Politics: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-434, 'ProjectDiscipline','63','Religion: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-435, 'ProjectDiscipline','67','Religion: Comparative Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-436, 'ProjectDiscipline','64','Religion: History of Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-437, 'ProjectDiscipline','66','Religion: Nonwestern Religion','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-438, 'ProjectDiscipline','2882','Religion: Other','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-439, 'ProjectDiscipline','141','Social Science: General','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-440, 'ProjectDiscipline','108','Social Science: Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-441, 'ProjectDiscipline','145','Social Science: Archaeology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-442, 'ProjectDiscipline','2863','Social Science: Biological Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-443, 'ProjectDiscipline','2862','Social Science: Cultural Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-444, 'ProjectDiscipline','119','Social Science: Economics','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-445, 'ProjectDiscipline','2865','Social Science: Ethnomusicology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-446, 'ProjectDiscipline','146','Social Science: Geography','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-447, 'ProjectDiscipline','2864','Social Science: Linguistic Anthropology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-448, 'ProjectDiscipline','144','Social Science: Psychology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-449, 'ProjectDiscipline','130','Social Science: Sociology','admin',sysdate,SYS_GUID());

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
values(-450, 'ProjectDiscipline','2866','Social Science: Other','admin',sysdate,SYS_GUID());
