---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


-- arg values
insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-458', 'FundingMechanism_CoverPage_1.9','Research','Research','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-459', 'FundingMechanism_CoverPage_1.9','RAPID','RAPID','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-460', 'FundingMechanism_CoverPage_1.9','EAGER','EAGER','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-461', 'FundingMechanism_CoverPage_1.9','RAISE','RAISE','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-462', 'FundingMechanism_CoverPage_1.9','GOALI','GOALI','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-463', 'FundingMechanism_CoverPage_1.9','Ideas Lab','Ideas Lab','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-464', 'FundingMechanism_CoverPage_1.9','FASED','FASED','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-465', 'FundingMechanism_CoverPage_1.9','Conference','Conference','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-466', 'FundingMechanism_CoverPage_1.9','Equipment','Equipment','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-467', 'FundingMechanism_CoverPage_1.9','Travel','Travel','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-468', 'FundingMechanism_CoverPage_1.9','Center','Center','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-469', 'FundingMechanism_CoverPage_1.9','Research Infrastructure','Research Infrastructure','admin',sysdate,sys_guid(),'Y');

insert into ARG_VALUE_LOOKUP (ARG_VALUE_LOOKUP_ID,ARGUMENT_NAME,VALUE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,ACTV_IND)
values('-470', 'FundingMechanism_CoverPage_1.9','Fellowship','Fellowship','admin',sysdate,sys_guid(),'Y');


Insert into QUESTIONNAIRE (QUESTIONNAIRE_REF_ID,QUESTIONNAIRE_ID,SEQUENCE_NUMBER,NAME,DESCRIPTION,UPDATE_TIMESTAMP,UPDATE_USER,IS_FINAL,VER_NBR,OBJ_ID,FILE_NAME)
values (SEQ_QUESTIONNAIRE_REF_ID.nextval,-6,1,'NSF cover page 1-9 supporting questions','These questions support NSF Coverpage 1-9 Grants.gov forms.',sysdate,'admin','Y',1,sys_guid(),null);

-- Connecting to this question was difficult because at least in kent data, there were multiple copies of this question with different versions
-- Generally, we should not require the max(QUESTION_REF_ID) in this solution
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),
        (select max(QUESTION_REF_ID) from question q1 where question = 'Are you currently serving (or have previously served) as a PI, co-PI or Program Director (PD) on any Federally funded project?' and SEQUENCE_NUMBER = (select max(SEQUENCE_NUMBER) from question q2 where q2.question = q1.question)),
        1,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- Select a Funding Mechanism
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values (SEQ_QUESTIONNAIRE_REF_ID.nextval,-10142,1,'C','Select a Funding Mechanism','A',2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','FundingMechanism_CoverPage_1.9',null,1,100,sysdate, 'admin',1,sys_guid(),null);


INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID = -10142),10,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- -10110 Have lobbying activities been conducted on behalf of this proposal? Disclosure of Lobbying Activities (PAPPG Chapter II.C.1.d and Exhibit II-5)
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10110 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10110)),
        11,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- -10111 Are you an NSF Beginning Investigator? (Proposal & Award Policies & Procedures Guide (PAPPG) Chapter II.D.2)
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10111 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10111)),2,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- -10112 Is this proposal an NSF Accomplishment Based renewal? (PAPPG Chapter V.B)
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10112 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10112)),5,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- -10143
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values (SEQ_QUESTIONNAIRE_REF_ID.nextval,-10143,1,'C','Would this result in the funding of an International Branch Campus of a U.S. IHE, including through use of a subaward or consultant arrangement (PAPPG Chapter I.E.1)','A',4,1,null,null,null,1,1,sysdate, 'admin',1,sys_guid(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID=-10143),12,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);

-- -10144
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values (SEQ_QUESTIONNAIRE_REF_ID.nextval,-10144,1,'C','Would this result in the funding of a Foreign Organization including through use of a subaward or consultant arrangement (PAPPG Chapter I.E.6)','A',4,1,null,null,null,1,1,sysdate, 'admin',1,sys_guid(),null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval,(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID=-10144),13,0,1,'N',null,null,'admin',sysdate,sys_guid(),1);


-- usage
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID,MODULE_ITEM_CODE,MODULE_SUB_ITEM_CODE,QUESTIONNAIRE_REF_ID_FK,QUESTIONNAIRE_SEQUENCE_NUMBER,RULE_ID,QUESTIONNAIRE_LABEL,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,IS_MANDATORY)
values (SEQ_QUESTIONNAIRE_REF_ID.nextval,3,(SELECT SUB_MODULE_CODE FROM COEUS_SUB_MODULE WHERE DESCRIPTION = 'S2S Questionnaires'),
        (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -6),
        1,null,'NSF 1-9 Cover Page questionnaire',sysdate,'admin',1,sys_guid(),'N');

insert into s2s_form_to_questionnaire
(S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.nextval, 'http://apply.grants.gov/forms/NSF_CoverPage_1_9-V1.9', 'NSF_CoverPage_1_9', -6, sysdate, 'admin', sys_guid(), '1');

