---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


-- This repairs possible errors in data caused by bugs that allowed periods to change without updating the
-- details within them.  Details start and end dates should always be within the period start and end dates.

-- When a budget personnel details has dates outside its containing period on both start and end, match the period
update (select d.start_date as detail_start, d.end_date as detail_end, p.start_date as period_start, p.end_date as period_end
        from budget_personnel_details d
                 join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
        where d.START_DATE < p.START_DATE
          and d.END_DATE > p.END_DATE) t
set t.detail_start = t.period_start,
    t.detail_end   = t.period_end;

-- When a budget personnel details has just the start date before the period start date.  We attempt to move the
-- entire detail period back by the amount it was outside the period window.  For example, if it started 1 day
-- before the period, we would attempt to shift it back by one day, but keep the end date within the period.
update (select d.start_date as detail_start, d.end_date as detail_end, p.start_date as period_start, p.end_date as period_end
        from budget_personnel_details d
                 join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
        where d.START_DATE < p.START_DATE) t
set t.detail_start = t.period_start,
    t.detail_end   = case
                         when t.detail_end + (t.period_start - t.detail_start) > t.period_end then t.period_end
                         else t.detail_end + (t.period_start - t.detail_start) end;

-- When a budget personnel details has just the end date before the period end date.  We apply the same strategy
-- ensuring that the start date remains within the period.
update (select d.start_date as detail_start, d.end_date as detail_end, p.start_date as period_start, p.end_date as period_end
        from budget_personnel_details d
                 join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
        where d.END_DATE > p.END_DATE) t
set t.detail_end   = t.period_end,
    t.detail_start = case
                         when t.detail_start - (t.detail_end - t.period_end) < t.period_start then t.period_start
                         else t.detail_start - (t.detail_end - t.period_end) end;
