---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'RR_SF424_4_0-V4.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter'), 'N', 'admin', SYSDATE, SYS_GUID());

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'RR_SF424_4_0-V4.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'Pre-Application'), 'N', 'admin', SYSDATE, SYS_GUID());

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'RR_SF424_4_0-V4.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_SFLLL_OtherExplanatory'), 'N', 'admin', SYSDATE, SYS_GUID());


INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/OrganizationInfo/DUNSID', 'The selected organization does not have DUNS number.', 'proposal.Organization/Location', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/PDPIContactInfo', 'Contact information missing for PD/PI, please make sure a Principal Investigator has been added.', 'keyPersonnel', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/PDPIContactInfo/Address', 'The country code for the PD/PI address is invalid.', 'keyPersonnel', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/PDPIContactInfo/Address/Street1', 'The PI address is invalid. Use the proposal person window to add a street address.', 'keyPersonnel', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/PDPIContactInfo/Address/Country', 'The PI country code is invalid. Use the proposal person window to fix this.', 'keyPersonnel', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/PDPIContactInfo/Address/City', 'The PI address is missing a city. Please use the Proposal Person window to fix this.', 'keyPersonnel', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ActivityTitle', 'Please enter the program title.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Address/Country', 'The country code for the AOR is not valid for Grants.gov.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Title', 'The AOR must have a title.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ProjectTitle', 'You are missing a project title.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/EstimatedProjectFunding/TotalEstimatedAmount', 'You are missing total budget amounts.', 'budgetVersions', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/EstimatedProjectFunding/TotalfedNonfedrequested', 'You are missing total budget amounts.', 'budgetVersions', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/EstimatedProjectFunding/EstimatedProgramIncome', 'You are missing total budget amounts.', 'budgetVersions', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo', 'You are missing a contact person for the proposal.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/StateID', 'Selected organization missing state.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/OrganizationInfo/Address/City', 'Selected organization missing city.', 'proposal.Organization/Location', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/OrganizationInfo/Address/County', 'Selected organization missing county.', 'proposal.Organization/Location', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/OrganizationInfo/Address/ZipPostalCode', 'Selected organization missing postal code.', 'proposal.Organization/Location', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/OrganizationInfo/Address', 'Selected organization missing address.', 'proposal.Organization/Location', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Name/FirstName', 'First name missing for proposal contact person, please verify the information in the Unit Administrator table.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Name/MiddleName', 'Middle name missing for contact person.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Name/LastName', 'Last name missing for proposal contact person, please verify the information in the Unit Administrator table.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Fax', 'Fax missing for contact person.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Email', 'Email address missing for contact person.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantType/ApplicantTypeCode', 'Applicant type missing.', 'proposal.SponsorProgramInformation', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/Location', 'Areas Affected by Project is required, please add this Abstract Type in the Abstracts and Attachments tab.', 'abstractsAttachments', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/EstimatedProjectFunding', 'Estimated Project funding missing.', 'budgetVersions', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Address', 'Missing AOR address.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Phone', 'Missing AOR phone number.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Fax', 'Missing AOR Fax.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/Email', 'Missing AOR email address.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/OrganizationName', 'Missing AOR organization name.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/DepartmentName', 'Missing AOR department name.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo/DivisionName', 'Missing AOR division name.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/AORInfo', 'Missing AOR information.', 'proposal', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/RR_SF424_4_0/ApplicantInfo/ContactPersonInfo/Phone', 'Phone number missing for proposal contact person, please verify the information in the Unit Administrator table.', 'grantsGov', SYSDATE, 'admin', 1, SYS_GUID());

UPDATE KRMS_TERM_PARM_T SET VAL = 'RR_SF424-V1.1,RR_SF424_1_2-V1.2,RR_SF424_2_0-V2.0,RR_SF424_Multi_Project_Cover_1_0-V1.0,RR_SF424_Multi_Project_Cover_2_0-V2.0,RR_SF424_3_0-V3.0,RR_SF424_4_0-V4.0'
WHERE TERM_PARM_ID = 'KC2004' AND TERM_ID = 'KC2004';
