-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE  award_alt_nbr_type_t  (
                                           ALT_NBR_TYPE_ID  varchar2(20) NOT NULL,
                                           DESCRIPTION  varchar2(200) NOT NULL,
                                           UPDATE_TIMESTAMP  date NOT NULL,
                                           UPDATE_USER  varchar2(60) NOT NULL,
                                           VER_NBR  int NOT NULL,
                                           OBJ_ID  varchar2(36),
                                           ACTV_IND  varchar2(1) DEFAULT 'Y' NOT NULL,
                                          PRIMARY KEY ( ALT_NBR_TYPE_ID )
);

CREATE TABLE  award_alt_number_t  (
                                         ALT_NBR_ID  varchar2(20) NOT NULL,
                                         AWARD_ID  number(22) NOT NULL,
                                         AWARD_NUMBER  varchar2(12) NOT NULL,
                                         SEQUENCE_NUMBER  number(4) NOT NULL,
                                         ALT_NBR_TYPE_ID  varchar2(20) NOT NULL,
                                         NBR  varchar2(200) NOT NULL,
                                         SHOW_ON_INV  varchar2(1),
                                         DESCRIPTION  varchar2(200),
                                         UPDATE_TIMESTAMP  date NOT NULL,
                                         UPDATE_USER  varchar2(60)NOT NULL,
                                         VER_NBR  int NOT NULL,
                                         OBJ_ID  varchar2(36),
                                        PRIMARY KEY ( ALT_NBR_ID )
);
   
ALTER TABLE AWARD_ALT_NUMBER_T 
ADD CONSTRAINT FK_AWARD_ALT_NUMBER
	FOREIGN KEY  (AWARD_ID) 
	REFERENCES AWARD(AWARD_ID);
	
ALTER TABLE AWARD_ALT_NUMBER_T 
ADD CONSTRAINT FK2_AWARD_ALT_NUMBER
	FOREIGN KEY  (ALT_NBR_TYPE_ID) 
	REFERENCES AWARD_ALT_NBR_TYPE_T(ALT_NBR_TYPE_ID);

CREATE SEQUENCE SEQ_AWARD_ALT_NBR INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE SEQUENCE SEQ_AWARD_ALT_NBR_TYPE INCREMENT BY 1 START WITH 1 NOCACHE;
