---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


ALTER TABLE KRLC_CNTRY_T ADD POSTAL_CNTRY_NM_V3 VARCHAR2(255);

-- prefill all new countries with previous value
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = POSTAL_CNTRY_NM;

INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XA', 'XAC', sys_guid(), 1, 'N', 'Y', 'Ashmore and Cartier Islands');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('QS', 'XBI', sys_guid(), 1, 'N', 'Y', 'Bassas da India');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('QZ', 'XQZ', sys_guid(), 1, 'N', 'Y', 'Akrotiri');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('BQ', 'BES', sys_guid(), 1, 'N', 'Y', 'Bonaire, Sint Eustatius, and Saba');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XC', 'XCS', sys_guid(), 1, 'N', 'Y', 'Coral Sea Islands');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('CW', 'CUW', sys_guid(), 1, 'N', 'Y', 'Curaçao');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XD', 'XXD', sys_guid(), 1, 'N', 'Y', 'Dhekelia');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('DG', 'DGA', sys_guid(), 1, 'N', 'Y', 'Diego Garcia');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XE', 'XEU', sys_guid(), 1, 'N', 'Y', 'Europa Island');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XG', 'XGZ', sys_guid(), 1, 'N', 'Y', 'Gaza Strip');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('QX', 'XGL', sys_guid(), 1, 'N', 'Y', 'Glorioso Islands');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XJ', 'XJM', sys_guid(), 1, 'N', 'Y', 'Jan Mayen');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('QU', 'XJN', sys_guid(), 1, 'N', 'Y', 'Juan De Nova Island');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XK', 'XKS', sys_guid(), 1, 'N', 'Y', 'Kosovo');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XP', 'XPR', sys_guid(), 1, 'N', 'Y', 'Paracel Islands');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('SX', 'SXM', sys_guid(), 1, 'N', 'Y', 'Sint Maarten');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('SS', 'SSD', sys_guid(), 1, 'N', 'Y', 'South Sudan');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XS', 'XSP', sys_guid(), 1, 'N', 'Y', 'Spratly Islands');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XR', 'XSV', sys_guid(), 1, 'N', 'Y', 'Svalbard');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XT', 'XTR', sys_guid(), 1, 'N', 'Y', 'Tromelin Island');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('CP', 'CPT', sys_guid(), 1, 'N', 'Y', 'Clipperton Island');
INSERT INTO KRLC_CNTRY_T (POSTAL_CNTRY_CD, ALT_POSTAL_CNTRY_CD, OBJ_ID, VER_NBR, PSTL_CNTRY_RSTRC_IND, ACTV_IND, POSTAL_CNTRY_NM_V3)
VALUES ('XW', 'XWB', sys_guid(), 1, 'N', 'Y', 'West Bank');

UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Bahamas, The' WHERE POSTAL_CNTRY_CD = 'BS';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'Bosnia and Herzegowina' WHERE POSTAL_CNTRY_CD = 'BA';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Brunei' WHERE POSTAL_CNTRY_CD = 'BN';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Cabo Verde' WHERE POSTAL_CNTRY_CD = 'CV';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Congo (Brazzaville)' WHERE POSTAL_CNTRY_CD = 'CG';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Congo (Kinshasa)' WHERE POSTAL_CNTRY_CD = 'CD';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Côte D''Ivoire' WHERE POSTAL_CNTRY_CD = 'CI';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Croatia' WHERE POSTAL_CNTRY_CD = 'HR';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Czechia' WHERE POSTAL_CNTRY_CD = 'CZ';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'East Timor' WHERE POSTAL_CNTRY_CD = 'TL';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Eswatini' WHERE POSTAL_CNTRY_CD = 'SZ';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Falkland Islands (Islas Malvinas)' WHERE POSTAL_CNTRY_CD = 'FK';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'French Southern and Antarctic Lands' WHERE POSTAL_CNTRY_CD = 'TF';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Gambia, The' WHERE POSTAL_CNTRY_CD = 'GM';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Heard Island and McDonald Islands' WHERE POSTAL_CNTRY_CD = 'HM';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Iran' WHERE POSTAL_CNTRY_CD = 'IR';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Korea, North' WHERE POSTAL_CNTRY_CD = 'KP';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Korea, South' WHERE POSTAL_CNTRY_CD = 'KR';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Laos' WHERE POSTAL_CNTRY_CD = 'LA';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Libya' WHERE POSTAL_CNTRY_CD = 'LY';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'North Macedonia' WHERE POSTAL_CNTRY_CD = 'MK';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Moldova' WHERE POSTAL_CNTRY_CD = 'MD';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Burma' WHERE POSTAL_CNTRY_CD = 'MM';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Pitcairn Islands' WHERE POSTAL_CNTRY_CD = 'PN';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Russia' WHERE POSTAL_CNTRY_CD = 'RU';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Saint Barthelemy' WHERE POSTAL_CNTRY_CD = 'BL';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Saint Helena, Ascension, and Tristan Da Cunha' WHERE POSTAL_CNTRY_CD = 'SH';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'St. Helena' WHERE POSTAL_CNTRY_CD = 'SH';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'St. Pierre and Miquelon' WHERE POSTAL_CNTRY_CD = 'PM';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'Slovakia (Slovak Republic)' WHERE POSTAL_CNTRY_CD = 'SK';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'South Georgia and the South Sandwich Islands' WHERE POSTAL_CNTRY_CD = 'GS';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Syria' WHERE POSTAL_CNTRY_CD = 'SY';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Tanzania' WHERE POSTAL_CNTRY_CD = 'TZ';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = 'Vatican City' WHERE POSTAL_CNTRY_CD = 'VA';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'Virgin Islands (British)' WHERE POSTAL_CNTRY_CD = 'VG';
UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM = 'Wallis and Futuna Islands' WHERE POSTAL_CNTRY_CD = 'WF';

UPDATE KRLC_CNTRY_T SET POSTAL_CNTRY_NM_V3 = null where POSTAL_CNTRY_CD in ('AN', 'PS', 'SJ', 'UM');

ALTER TABLE KRLC_CNTRY_T ADD CONSTRAINT KR_COUNTRY_ALT_U UNIQUE (ALT_POSTAL_CNTRY_CD);

-- states update
ALTER TABLE KRLC_ST_T ADD POSTAL_STATE_NM_V3 VARCHAR2(50);
ALTER TABLE KRLC_ST_T MODIFY POSTAL_STATE_NM VARCHAR2(50);

-- prefill all new states with previous value
UPDATE KRLC_ST_T SET POSTAL_STATE_NM_V3 = POSTAL_STATE_NM;

UPDATE KRLC_ST_T SET POSTAL_STATE_NM_V3 = 'VIRGIN ISLANDS' WHERE POSTAL_STATE_CD = 'VI' AND POSTAL_CNTRY_CD = 'US';
UPDATE KRLC_ST_T SET POSTAL_STATE_NM = 'APO/FPO CENTRAL AND SOUTH AMERICA' WHERE POSTAL_STATE_CD = 'AA' AND POSTAL_CNTRY_CD = 'US';
UPDATE KRLC_ST_T SET POSTAL_STATE_NM_V3 = 'ARMED FORCES EUROPE, THE MIDDLE EAST, AND CANADA' WHERE POSTAL_STATE_CD = 'AE' AND POSTAL_CNTRY_CD = 'US';
UPDATE KRLC_ST_T SET POSTAL_STATE_NM = 'APO/FPO EUROPE, MIDDLE EAST, AND AFRICA' WHERE POSTAL_STATE_CD = 'AE' AND POSTAL_CNTRY_CD = 'US';
UPDATE KRLC_ST_T SET POSTAL_STATE_NM = 'APO/FPO KOREA, JAPAN, PHILIPPINES, OTHER PACIFIC' WHERE POSTAL_STATE_CD = 'AP' AND POSTAL_CNTRY_CD = 'US';
