/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.base;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jute.base.Precondition;

public final class Optionals {
    private static final long NEGATIVE_ONE = -1L;

    public static Optional<Integer> optionalInteger(String text) {
        Optional<String> optional = Optionals.fromTrimToNull(text);
        if (optional.isPresent()) {
            int value = Integer.parseInt((String)optional.get());
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public static Optional<Integer> fromMissingOrZeroToAbsent(String text) {
        Optional<Integer> optional = Optionals.optionalInteger(text);
        if (optional.isPresent() && (Integer)optional.get() == 0) {
            return Optional.absent();
        }
        return optional;
    }

    public static int countPresent(Optional<?> ... optionals) {
        int present = 0;
        for (Optional<?> optional : optionals) {
            present = optional.isPresent() ? present + 1 : present;
        }
        return present;
    }

    public static long fromAbsentToNegative(Optional<Long> optional) {
        return Optionals.fromAbsentToNegative(optional, -1L);
    }

    public static long fromAbsentToNegative(Optional<Long> optional, long negativeValue) {
        Precondition.checkMax(negativeValue, -1L, "negativeValue");
        if (optional.isPresent()) {
            return (Long)optional.get();
        }
        return negativeValue;
    }

    public static Optional<Double> fromNegativeToAbsent(double value) {
        if (value < 0.0) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public static Optional<Long> fromNegativeToAbsent(long value) {
        if (value < 0L) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public static Optional<Integer> fromPositiveToPresent(int value) {
        if (value > 0) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public static Optional<Integer> fromZeroToAbsent(int value) {
        if (value == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public static Optional<Integer> fromNegativeToAbsent(int value) {
        if (value < 0) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public static Optional<Long> fromNullableDate(Date date) {
        if (date == null) {
            return Optional.absent();
        }
        return Optional.of((Object)date.getTime());
    }

    public static Optional<String> fromTrimToNull(String s) {
        return Optional.fromNullable((Object)StringUtils.trimToNull((String)s));
    }

    public static Optional<String> fromEmptyToNull(String s) {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)s));
    }
}

