/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.base;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.base.RunningStopwatch;

@JsonDeserialize(builder=Builder.class)
public final class TimedInterval {
    private final long start;
    private final long stop;
    private final long elapsed;

    private TimedInterval(Builder builder) {
        this.start = builder.start;
        this.stop = builder.stop;
        this.elapsed = builder.elapsed;
    }

    public static TimedInterval build(RunningStopwatch sw) {
        return TimedInterval.build(sw.elapsedMillis());
    }

    public static TimedInterval build(Stopwatch sw) {
        return TimedInterval.build(sw.elapsed(TimeUnit.MILLISECONDS));
    }

    public static TimedInterval build(long elapsed) {
        long stop = System.currentTimeMillis();
        long start = stop - elapsed;
        return TimedInterval.builder().withStart(start).withStop(stop).withElapsed(elapsed).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("stop", this.stop).add("elapsed", this.elapsed).toString();
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<TimedInterval> {
        private long start;
        private long stop;
        private long elapsed;

        public Builder withStart(long start) {
            this.start = start;
            return this;
        }

        public Builder withStop(long stop) {
            this.stop = stop;
            return this;
        }

        public Builder withElapsed(long elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public TimedInterval build() {
            return Builder.validate(new TimedInterval(this));
        }

        private static TimedInterval validate(TimedInterval instance) {
            Precondition.checkMin(instance.stop, instance.start, "stop");
            Precondition.checkEquals(instance.elapsed, instance.stop - instance.start, "elapsed");
            return instance;
        }
    }
}

