/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.collect;

import com.google.common.base.Function;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.base.Reducer;

public class Iterables {
    public static <T> T getSingleElement(Iterable<T> iterable) {
        return Precondition.checkSize(iterable, 1).iterator().next();
    }

    public static <A, B, C> C mapreduce(Iterable<A> iterable, Function<A, B> mapper, C initial, Reducer<B, C> reducer) {
        Iterable transformed = com.google.common.collect.Iterables.transform(iterable, mapper);
        return Iterables.reduce(transformed, initial, reducer);
    }

    public static <A, B> B reduce(Iterable<A> iterable, B initial, Reducer<A, B> reducer) {
        B value = initial;
        for (A element : iterable) {
            value = reducer.apply(value, element);
        }
        return value;
    }
}

