/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.kuali.common.jute.base.Precondition;

public final class Lists {
    public static <T> List<T> shuffle(List<T> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <T> List<T> shuffledCopy(List<T> list) {
        return Lists.shuffle(com.google.common.collect.Lists.newArrayList(list));
    }

    public static <T> List<T> immutableShuffledCopy(List<T> list) {
        return ImmutableList.copyOf(Lists.shuffledCopy(list));
    }

    public static <T> List<List<T>> distribute(List<T> list, int partitions) {
        Preconditions.checkNotNull(list);
        Precondition.checkMin(partitions, 1, "partitions");
        return list instanceof RandomAccess ? new RandomAccessDistribution<T>(list, partitions) : new Distribution<T>(list, partitions);
    }

    public static <T> List<List<T>> scatter(Iterable<T> iterable, int partitions, Function<T, Double> weigher) {
        Precondition.checkNotNull(iterable, "iterable");
        Precondition.checkMin(partitions, 1, "partitions");
        Precondition.checkNotNull(weigher, "weigher");
        List weighed = Ordering.natural().reverse().sortedCopy(Lists.weighElements(iterable, weigher));
        List<List<T>> container = Lists.newContainer(Math.min(weighed.size(), partitions));
        if (!weighed.isEmpty()) {
            Lists.fillContainer(container, weighed);
        }
        return Lists.immutableCopy(container);
    }

    private static <T> List<List<T>> newContainer(int size) {
        ArrayList container = com.google.common.collect.Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            ArrayList list = com.google.common.collect.Lists.newArrayList();
            container.add(list);
        }
        return container;
    }

    private static <T> void fillContainer(List<List<T>> container, List<Weighed<T>> sorted) {
        ArrayList weightIndexes = com.google.common.collect.Lists.newArrayList();
        for (int i = 0; i < container.size(); ++i) {
            weightIndexes.add(new WeightIndex(i));
        }
        Ordering ordering = Ordering.from((Comparator)WeightIndexComparator.INSTANCE);
        WeightIndex min = (WeightIndex)ordering.min((Iterable)weightIndexes);
        for (Weighed<T> element : sorted) {
            int index = min.getIndex();
            List<T> list = container.get(index);
            T value = element.getElement();
            list.add(value);
            double weight = min.getWeight() + element.getWeight();
            min.setWeight(weight);
            min = (WeightIndex)ordering.min((Iterable)weightIndexes);
        }
    }

    private static <T> List<List<T>> immutableCopy(List<List<T>> container) {
        ArrayList list = com.google.common.collect.Lists.newArrayList();
        for (List<T> element : container) {
            list.add(ImmutableList.copyOf(element));
        }
        return ImmutableList.copyOf((Collection)list);
    }

    private static <T> List<Weighed<T>> weighElements(Iterable<T> list, Function<T, Double> weigher) {
        ArrayList weighted = com.google.common.collect.Lists.newArrayList();
        for (T element : list) {
            double weight = (Double)weigher.apply(element);
            Weighed<T> weighed = Lists.newWeighed(element, weight);
            weighted.add(weighed);
        }
        return weighted;
    }

    private static <T> Weighed<T> newWeighed(T element, double weight) {
        return new Weighed<T>(element, weight);
    }

    private static class RandomAccessDistribution<T>
    extends Distribution<T>
    implements RandomAccess {
        public RandomAccessDistribution(List<T> list, int parts) {
            super(list, parts);
        }
    }

    private static class Distribution<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int partitions;

        Distribution(List<T> list, int partitions) {
            this.list = list;
            this.partitions = partitions;
        }

        @Override
        public List<T> get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size());
            int listSize = this.list.size();
            int normalPartitions = listSize % this.partitions;
            int partialPartitionSize = listSize / this.partitions;
            int normalPartitionSize = partialPartitionSize + 1;
            if (index < normalPartitions) {
                int chunkStart = normalPartitionSize * index;
                return this.list.subList(chunkStart, chunkStart + normalPartitionSize);
            }
            int normalEnd = normalPartitions * normalPartitionSize;
            int chunkStart = normalEnd + (index - normalPartitions) * partialPartitionSize;
            return this.list.subList(chunkStart, chunkStart + partialPartitionSize);
        }

        @Override
        public int size() {
            return this.partitions;
        }
    }

    private static class WeightIndex {
        private final int index;
        private double weight;

        public WeightIndex(int index) {
            this.index = Preconditions.checkElementIndex((int)index, (int)Integer.MAX_VALUE);
        }

        public int getIndex() {
            return this.index;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }
    }

    private static enum WeightIndexComparator implements Comparator<WeightIndex>
    {
        INSTANCE;


        @Override
        public int compare(WeightIndex one, WeightIndex two) {
            return Double.compare(one.getWeight(), two.getWeight());
        }
    }

    private static class Weighed<T>
    implements Comparable<Weighed<T>> {
        private final T element;
        private final double weight;

        public Weighed(T element, double weight) {
            this.element = Preconditions.checkNotNull(element);
            this.weight = weight;
        }

        @Override
        public int compareTo(Weighed<T> other) {
            return Doubles.compare((double)this.weight, (double)other.getWeight());
        }

        public T getElement() {
            return this.element;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

