/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.enc.openssl;

import org.kuali.common.jute.reflect.Reflection;

public final class OpenSSLSaltContext {
    private final String prefix;
    private final int bytes;
    private final boolean secure;

    private OpenSSLSaltContext(Builder builder) {
        this.prefix = builder.prefix;
        this.bytes = builder.bytes;
        this.secure = builder.secure;
    }

    public static OpenSSLSaltContext build() {
        return OpenSSLSaltContext.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getBytes() {
        return this.bytes;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<OpenSSLSaltContext> {
        private String prefix = "Salted__";
        private int bytes = 8;
        private boolean secure = true;

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withBytes(int bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public OpenSSLSaltContext build() {
            return Reflection.checkNoNulls(new OpenSSLSaltContext(this));
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public int getBytes() {
            return this.bytes;
        }

        public void setBytes(int bytes) {
            this.bytes = bytes;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }
    }
}

