/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.enc.openssl;

import javax.inject.Inject;
import javax.inject.Provider;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.enc.openssl.OpenSSLSaltContext;
import org.kuali.common.jute.env.Environment;

public final class OpenSSLSaltContextProvider
implements Provider<OpenSSLSaltContext> {
    private final Environment env;

    @Inject
    public OpenSSLSaltContextProvider(Environment env) {
        this.env = Precondition.checkNotNull(env, "env");
    }

    public OpenSSLSaltContext get() {
        OpenSSLSaltContext.Builder builder = OpenSSLSaltContext.builder();
        builder.withBytes(Integer.parseInt(this.env.getProperty("openssl.salt.bytes", builder.getBytes() + "")));
        builder.withPrefix(this.env.getProperty("openssl.salt.prefix", builder.getPrefix()));
        builder.withSecure(Boolean.parseBoolean(this.env.getProperty("openssl.salt.secure", builder.isSecure() + "")));
        return builder.build();
    }
}

