/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.json.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.Closer;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.inject.Inject;
import org.kuali.common.jute.base.Exceptions;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.json.JsonService;

public final class JacksonJsonService
implements JsonService {
    private final ObjectMapper mapper;

    @Inject
    public JacksonJsonService(ObjectMapper mapper) {
        this.mapper = mapper.copy();
    }

    @Override
    public <T> T readString(String json, Class<T> valueType) {
        try {
            ByteSource source = ByteSource.wrap((byte[])json.getBytes(Charsets.UTF_8));
            return this.read(source, valueType);
        }
        catch (IOException e) {
            throw Exceptions.illegalState("unexpected io error");
        }
    }

    @Override
    public <T> T read(String url, Class<T> type) throws IOException {
        Precondition.checkNotBlank(url, "url");
        return this.read(new URL(url), type);
    }

    @Override
    public <T> T read(URL url, Class<T> type) throws IOException {
        return this.read(Resources.asByteSource((URL)url), type);
    }

    @Override
    public <T> T read(File file, Class<T> type) throws IOException {
        return this.read(Files.asByteSource((File)file), type);
    }

    @Override
    public <T> T read(ByteSource source, Class<T> valueType) throws IOException {
        Precondition.checkNotNull(source, "source");
        Precondition.checkNotNull(valueType, "valueType");
        try (Closer closer = Closer.create();){
            InputStream in = (InputStream)closer.register((Closeable)source.openBufferedStream());
            Object object = this.mapper.readValue(in, valueType);
            return (T)object;
        }
    }

    @Override
    public <T> String writeString(T reference) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out, reference);
            return out.toString(Charsets.UTF_8.name());
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e, "unexpected io error", new Object[0]);
        }
    }

    private <T> void write(OutputStream out, T reference) throws IOException {
        this.mapper.writeValue(out, reference);
    }

    @Override
    public <T> void write(ByteSink sink, T reference) throws IOException {
        try (Closer closer = Closer.create();){
            OutputStream out = (OutputStream)closer.register((Closeable)sink.openBufferedStream());
            this.write(out, reference);
        }
    }

    @Override
    public <T> void write(File file, T reference) throws IOException {
        ByteSink sink = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
        Files.createParentDirs((File)file);
        this.write(sink, reference);
    }
}

