/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.net;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.jute.base.Precondition;

@JsonDeserialize(builder=Builder.class)
public final class InetAddress {
    private final String hostName;
    private final String canonicalHostName;
    private final String hostAddress;

    private InetAddress(Builder builder) {
        this.canonicalHostName = builder.canonicalHostName;
        this.hostName = builder.hostName;
        this.hostAddress = builder.hostAddress;
    }

    public static InetAddress buildLocalHost() throws IOException {
        return InetAddress.copyOf(java.net.InetAddress.getLocalHost());
    }

    public static List<InetAddress> copyOf(Iterable<java.net.InetAddress> mutables) {
        ArrayList list = Lists.newArrayList();
        for (java.net.InetAddress mutable : mutables) {
            list.add(InetAddress.copyOf(mutable));
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public static InetAddress copyOf(java.net.InetAddress mutable) {
        Builder builder = InetAddress.builder();
        builder.withCanonicalHostName(mutable.getCanonicalHostName());
        builder.withHostAddress(mutable.getHostAddress());
        builder.withHostName(mutable.getHostName());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<InetAddress> {
        private String canonicalHostName;
        private String hostName;
        private String hostAddress;

        public Builder withCanonicalHostName(String canonicalHostName) {
            this.canonicalHostName = canonicalHostName;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public InetAddress build() {
            return Builder.validate(new InetAddress(this));
        }

        private static InetAddress validate(InetAddress instance) {
            Precondition.checkNotBlank(instance.hostName, "hostName");
            Precondition.checkNotBlank(instance.canonicalHostName, "canonicalHostName");
            Precondition.checkNotBlank(instance.hostAddress, "hostAddress");
            return instance;
        }
    }
}

