/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.net;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.net.InetAddress;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class InterfaceAddress {
    private final InetAddress address;
    private final Optional<InetAddress> broadcast;
    private final int networkPrefixLength;

    private InterfaceAddress(Builder builder) {
        this.address = builder.address;
        this.broadcast = builder.broadcast;
        this.networkPrefixLength = builder.networkPrefixLength;
    }

    public static InterfaceAddress copyOf(java.net.InterfaceAddress mutable) {
        Builder builder = InterfaceAddress.builder();
        builder.withAddress(InetAddress.copyOf(mutable.getAddress()));
        if (mutable.getBroadcast() != null) {
            InetAddress broadcast = InetAddress.copyOf(mutable.getBroadcast());
            builder.withBroadcast((Optional<InetAddress>)Optional.of((Object)broadcast));
        }
        builder.withNetworkPrefixLength(mutable.getNetworkPrefixLength());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public Optional<InetAddress> getBroadcast() {
        return this.broadcast;
    }

    public int getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<InterfaceAddress> {
        private InetAddress address;
        private Optional<InetAddress> broadcast = Optional.absent();
        private int networkPrefixLength = -1;

        public Builder withNetworkPrefixLength(int networkPrefixLength) {
            this.networkPrefixLength = networkPrefixLength;
            return this;
        }

        public Builder withAddress(InetAddress address) {
            this.address = address;
            return this;
        }

        public Builder withBroadcast(Optional<InetAddress> broadcast) {
            this.broadcast = broadcast;
            return this;
        }

        public InterfaceAddress build() {
            return Builder.validate(new InterfaceAddress(this));
        }

        private static InterfaceAddress validate(InterfaceAddress instance) {
            Reflection.checkNoNulls(instance);
            Precondition.checkMin(instance.networkPrefixLength, 0, "networkPrefixLength");
            return instance;
        }
    }
}

