/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.net;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.net.InetAddress;
import org.kuali.common.jute.net.InterfaceAddress;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class NetworkInterface {
    private final Optional<NetworkInterface> parent;
    private final String name;
    private final String displayName;
    private final ImmutableList<InetAddress> addresses;
    private final ImmutableList<NetworkInterface> subInterfaces;
    private final ImmutableList<InterfaceAddress> interfaceAddresses;
    private final Optional<Integer> index;
    private final int mtu;
    private final boolean loopback;
    private final boolean pointToPoint;
    private final boolean up;
    private final boolean virtual;
    private final boolean supportsMulticast;
    private final Optional<String> hardwareAddress;

    public static List<NetworkInterface> copyOf(Iterable<java.net.NetworkInterface> mutables) throws IOException {
        ArrayList list = Lists.newArrayList();
        for (java.net.NetworkInterface mutable : mutables) {
            list.add(NetworkInterface.copyOf(mutable));
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public static NetworkInterface copyOf(java.net.NetworkInterface mutable) throws IOException {
        Builder builder = NetworkInterface.builder();
        builder.withName(mutable.getName());
        builder.withAddresses(InetAddress.copyOf(Collections.list(mutable.getInetAddresses())));
        builder.withDisplayName(mutable.getDisplayName());
        builder.withIndex(Optionals.fromNegativeToAbsent(mutable.getIndex()));
        builder.withMtu(mutable.getMTU());
        builder.withLoopback(mutable.isLoopback());
        builder.withPointToPoint(mutable.isPointToPoint());
        builder.withUp(mutable.isUp());
        builder.withVirtual(mutable.isVirtual());
        builder.withSupportsMulticast(mutable.supportsMulticast());
        builder.withHardwareAddress(NetworkInterface.getHardwareAddress(mutable.getHardwareAddress()));
        builder.withSubInterfaces(NetworkInterface.copyOf(Collections.list(mutable.getSubInterfaces())));
        return builder.build();
    }

    public static Optional<String> getHardwareAddress(byte[] address) {
        if (address == null) {
            return Optional.absent();
        }
        BaseEncoding encoder = BaseEncoding.base16().lowerCase();
        ArrayList lines = Lists.newArrayList();
        for (int i = 0; i < address.length; ++i) {
            lines.add(encoder.encode(address, i, 1));
        }
        return Optional.of((Object)Joiner.on((char)':').join((Iterable)lines));
    }

    public static Builder builder() {
        return new Builder();
    }

    private NetworkInterface(Builder builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.addresses = ImmutableList.copyOf((Collection)builder.addresses);
        this.index = builder.index;
        this.mtu = builder.mtu;
        this.loopback = builder.loopback;
        this.pointToPoint = builder.pointToPoint;
        this.up = builder.up;
        this.virtual = builder.virtual;
        this.supportsMulticast = builder.supportsMulticast;
        this.hardwareAddress = builder.hardwareAddress;
        this.parent = builder.parent;
        this.subInterfaces = ImmutableList.copyOf((Collection)builder.subInterfaces);
        this.interfaceAddresses = ImmutableList.copyOf((Collection)builder.interfaceAddresses);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<InetAddress> getAddresses() {
        return this.addresses;
    }

    public Optional<Integer> getIndex() {
        return this.index;
    }

    public int getMtu() {
        return this.mtu;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public boolean isPointToPoint() {
        return this.pointToPoint;
    }

    public boolean isUp() {
        return this.up;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isSupportsMulticast() {
        return this.supportsMulticast;
    }

    public Optional<String> getHardwareAddress() {
        return this.hardwareAddress;
    }

    public Optional<NetworkInterface> getParent() {
        return this.parent;
    }

    public List<NetworkInterface> getSubInterfaces() {
        return this.subInterfaces;
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        return this.interfaceAddresses;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<NetworkInterface> {
        private Optional<NetworkInterface> parent = Optional.absent();
        private String name;
        private String displayName;
        private Optional<Integer> index = Optional.absent();
        private int mtu = -1;
        private List<InetAddress> addresses = Lists.newArrayList();
        private boolean loopback;
        private boolean pointToPoint;
        private boolean up;
        private boolean virtual;
        private boolean supportsMulticast;
        private Optional<String> hardwareAddress = Optional.absent();
        private List<NetworkInterface> subInterfaces = Lists.newArrayList();
        private List<InterfaceAddress> interfaceAddresses = Lists.newArrayList();

        public Builder withInterfaceAddresses(List<InterfaceAddress> interfaceAddresses) {
            this.interfaceAddresses = interfaceAddresses;
            return this;
        }

        public Builder withSubInterfaces(List<NetworkInterface> subInterfaces) {
            this.subInterfaces = subInterfaces;
            return this;
        }

        @JsonSetter
        public Builder withParent(Optional<NetworkInterface> parent) {
            this.parent = parent;
            return this;
        }

        public Builder withParent(NetworkInterface parent) {
            return this.withParent((Optional<NetworkInterface>)Optional.of((Object)parent));
        }

        public Builder withHardwareAddress(Optional<String> hardwareAddress) {
            this.hardwareAddress = hardwareAddress;
            return this;
        }

        public Builder withSupportsMulticast(boolean supportsMulticast) {
            this.supportsMulticast = supportsMulticast;
            return this;
        }

        public Builder withVirtual(boolean virtual) {
            this.virtual = virtual;
            return this;
        }

        public Builder withUp(boolean up) {
            this.up = up;
            return this;
        }

        public Builder withPointToPoint(boolean pointToPoint) {
            this.pointToPoint = pointToPoint;
            return this;
        }

        public Builder withLoopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder withMtu(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public Builder withIndex(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withAddresses(List<InetAddress> addresses) {
            this.addresses = addresses;
            return this;
        }

        public NetworkInterface build() {
            return Builder.validate(new NetworkInterface(this));
        }

        private static NetworkInterface validate(NetworkInterface instance) {
            Reflection.checkNoNulls(instance);
            Precondition.checkNotBlank(instance.name, "name");
            Precondition.checkNotBlank(instance.displayName, "displayName");
            Precondition.checkNotBlank((Optional<String>)instance.hardwareAddress, "hardwareAddress");
            Precondition.checkMin((Optional<Integer>)instance.index, 0, "index");
            Precondition.checkMin(instance.mtu, 0, "mtu");
            return instance;
        }
    }
}

