/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.reflect;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.kuali.common.jute.base.Exceptions;

public final class Reflection {
    private static final Map<Class<?>, ImmutableSet<Field>> CACHE = Maps.newConcurrentMap();

    private Reflection() {
    }

    public static <T> T checkNoNulls(T instance) {
        for (Field field : Reflection.getFields(instance.getClass())) {
            if (Reflection.getValue(field, instance) != null) continue;
            throw Exceptions.nullPointerException("%s.%s cannot be null", instance.getClass().getSimpleName(), field.getName());
        }
        return instance;
    }

    private static ImmutableSet<Field> getFields(Class<?> type) {
        ImmutableSet fields = CACHE.get(type);
        if (fields == null) {
            HashSet mutable = Sets.newHashSet();
            for (Class<?> c = type; c != null; c = c.getSuperclass()) {
                for (Field field : type.getDeclaredFields()) {
                    field.setAccessible(true);
                    mutable.add(field);
                }
            }
            fields = ImmutableSet.copyOf((Collection)mutable);
            CACHE.put(type, (ImmutableSet<Field>)fields);
        }
        return fields;
    }

    private static <T> Object getValue(Field field, T instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.illegalState(e);
        }
    }
}

