/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import org.kuali.common.jute.base.Precondition;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class ClassLoading {
    private final int current;
    private final long total;
    private final long unloaded;

    private ClassLoading(Builder builder) {
        this.current = builder.current;
        this.total = builder.total;
        this.unloaded = builder.unloaded;
    }

    public static ClassLoading build() {
        ClassLoadingMXBean bean = ManagementFactory.getClassLoadingMXBean();
        Builder builder = ClassLoading.builder();
        builder.withCurrent(bean.getLoadedClassCount());
        builder.withTotal(bean.getTotalLoadedClassCount());
        builder.withUnloaded(bean.getUnloadedClassCount());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getCurrent() {
        return this.current;
    }

    public long getTotal() {
        return this.total;
    }

    public long getUnloaded() {
        return this.unloaded;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<ClassLoading> {
        private int current;
        private long total;
        private long unloaded;

        public Builder withCurrent(int current) {
            this.current = current;
            return this;
        }

        public Builder withTotal(long total) {
            this.total = total;
            return this;
        }

        public Builder withUnloaded(long unloaded) {
            this.unloaded = unloaded;
            return this;
        }

        public ClassLoading build() {
            return Builder.validate(new ClassLoading(this));
        }

        private static ClassLoading validate(ClassLoading instance) {
            Reflection.checkNoNulls(instance);
            Precondition.checkMin(instance.current, 0, "current");
            Precondition.checkMin(instance.total, 0L, "total");
            Precondition.checkMin(instance.unloaded, 0L, "unloaded");
            return instance;
        }
    }
}

