/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.kuali.common.jute.base.Precondition;

@JsonDeserialize(builder=Builder.class)
public final class Memory {
    private final long used;
    private final long free;
    private final long allocated;
    private final long max;

    private Memory(Builder builder) {
        this.used = builder.used;
        this.free = builder.free;
        this.allocated = builder.allocated;
        this.max = builder.max;
    }

    public static Memory build() {
        long max = Runtime.getRuntime().maxMemory();
        long allocated = Runtime.getRuntime().totalMemory();
        long used = allocated - Runtime.getRuntime().freeMemory();
        long free = max - used;
        return Memory.builder().withAllocated(allocated).withFree(free).withMax(max).withUsed(used).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getUsed() {
        return this.used;
    }

    public long getFree() {
        return this.free;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public long getMax() {
        return this.max;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<Memory> {
        private long max;
        private long allocated;
        private long used;
        private long free;

        public Builder withUsed(long used) {
            this.used = used;
            return this;
        }

        public Builder withFree(long free) {
            this.free = free;
            return this;
        }

        public Builder withAllocated(long allocated) {
            this.allocated = allocated;
            return this;
        }

        public Builder withMax(long max) {
            this.max = max;
            return this;
        }

        public Memory build() {
            return Builder.validate(new Memory(this));
        }

        private static Memory validate(Memory instance) {
            Precondition.checkMin(instance.used, 0L, "used");
            Precondition.checkMin(instance.free, 0L, "free");
            Precondition.checkMin(instance.allocated, 0L, "allocated");
            Precondition.checkMin(instance.max, 0L, "max");
            return instance;
        }
    }
}

