/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.lang.management.ManagementFactory;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;

public enum ProcessIdProvider implements Provider<Optional<Integer>>
{
    INSTANCE;


    public Optional<Integer> get() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            Iterable tokens = Splitter.on((char)'@').split((CharSequence)name);
            String first = (String)Iterables.getFirst((Iterable)tokens, null);
            String trimmed = StringUtils.trimToNull((String)first);
            if (trimmed == null) {
                return Optional.absent();
            }
            int pid = Integer.parseInt(trimmed);
            return Optional.of((Object)pid);
        }
        catch (Throwable e) {
            return Optional.absent();
        }
    }
}

