/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.inject.Provider;
import org.kuali.common.jute.base.Optionals;
import org.kuali.common.jute.inject.TypeLiterals;
import org.kuali.common.jute.runtime.ClassLoading;
import org.kuali.common.jute.runtime.GarbageCollectionEvent;
import org.kuali.common.jute.runtime.Memory;
import org.kuali.common.jute.runtime.ProcessIdProvider;
import org.kuali.common.jute.runtime.Threads;
import org.kuali.common.jute.runtime.Uptime;
import org.kuali.common.jute.runtime.VirtualRuntime;
import org.kuali.common.jute.runtime.annotation.GarbageCollectionEvents;
import org.kuali.common.jute.runtime.annotation.ProcessId;
import org.kuali.common.jute.runtime.annotation.Processors;
import org.kuali.common.jute.runtime.annotation.SystemLoadAverage;

public class RuntimeModule
extends AbstractModule {
    protected void configure() {
        this.bindConstant().annotatedWith(Processors.class).to(Runtime.getRuntime().availableProcessors());
        this.bind(Memory.class).toProvider((Provider)MemoryProvider.INSTANCE);
        this.bind(Uptime.class).toProvider((Provider)UptimeProvider.INSTANCE);
        this.bind(TypeLiterals.optionalInteger()).annotatedWith(ProcessId.class).toProvider((Provider)ProcessIdProvider.INSTANCE).asEagerSingleton();
        this.bind(ClassLoading.class).toProvider((Provider)ClassLoadingProvider.INSTANCE);
        this.bind(Threads.class).toProvider((Provider)ThreadsProvider.INSTANCE);
        this.bind(RuntimeModule.garbageCollectionEventList()).annotatedWith(GarbageCollectionEvents.class).toProvider((Provider)GarbageCollectionEventsProvider.INSTANCE);
        this.bind(TypeLiterals.optionalDouble()).annotatedWith(SystemLoadAverage.class).toProvider((Provider)SystemLoadAverageProvider.INSTANCE);
        this.bind(VirtualRuntime.class).toProvider(VirtualRuntime.Builder.class);
    }

    private static TypeLiteral<List<GarbageCollectionEvent>> garbageCollectionEventList() {
        return new TypeLiteral<List<GarbageCollectionEvent>>(){};
    }

    private static enum ThreadsProvider implements Provider<Threads>
    {
        INSTANCE;


        public Threads get() {
            return Threads.build();
        }
    }

    private static enum GarbageCollectionEventsProvider implements Provider<List<GarbageCollectionEvent>>
    {
        INSTANCE;


        public List<GarbageCollectionEvent> get() {
            return GarbageCollectionEvent.buildAll();
        }
    }

    private static enum ClassLoadingProvider implements Provider<ClassLoading>
    {
        INSTANCE;


        public ClassLoading get() {
            return ClassLoading.build();
        }
    }

    private static enum UptimeProvider implements Provider<Uptime>
    {
        INSTANCE;


        public Uptime get() {
            return Uptime.build();
        }
    }

    private static enum SystemLoadAverageProvider implements Provider<Optional<Double>>
    {
        INSTANCE;


        public Optional<Double> get() {
            return Optionals.fromNegativeToAbsent(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        }
    }

    private static enum MemoryProvider implements Provider<Memory>
    {
        INSTANCE;


        public Memory get() {
            return Memory.build();
        }
    }
}

