/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.kuali.common.jute.base.Precondition;

@JsonDeserialize(builder=Builder.class)
public final class Threads {
    private final int current;
    private final int daemon;
    private final int peak;

    private Threads(Builder builder) {
        this.current = builder.current;
        this.daemon = builder.daemon;
        this.peak = builder.peak;
    }

    public static Threads build() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        Builder builder = Threads.builder();
        builder.withCurrent(bean.getThreadCount());
        builder.withDaemon(bean.getDaemonThreadCount());
        builder.withPeak(bean.getPeakThreadCount());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getCurrent() {
        return this.current;
    }

    public int getDaemon() {
        return this.daemon;
    }

    public int getPeak() {
        return this.peak;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<Threads> {
        private int current;
        private int daemon;
        private int peak;

        public Builder withCurrent(int current) {
            this.current = current;
            return this;
        }

        public Builder withDaemon(int daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder withPeak(int peak) {
            this.peak = peak;
            return this;
        }

        public Threads build() {
            return Builder.validate(new Threads(this));
        }

        private static Threads validate(Threads instance) {
            Precondition.checkMin(instance.current, 0, "current");
            Precondition.checkMin(instance.daemon, 0, "daemon");
            Precondition.checkMin(instance.peak, 0, "peak");
            return instance;
        }
    }
}

