/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.lang.management.ManagementFactory;
import org.kuali.common.jute.base.Precondition;

@JsonDeserialize(builder=Builder.class)
public final class Uptime {
    private final long start;
    private final long now;
    private final long elapsed;

    private Uptime(Builder builder) {
        this.start = builder.start;
        this.now = builder.now;
        this.elapsed = builder.elapsed;
    }

    public static Uptime build() {
        long now = System.currentTimeMillis();
        long start = ManagementFactory.getRuntimeMXBean().getStartTime();
        long elapsed = now - start;
        return Uptime.builder().withStart(start).withNow(now).withElapsed(elapsed).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getStart() {
        return this.start;
    }

    public long getNow() {
        return this.now;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("now", this.now).add("elapsed", this.elapsed).toString();
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<Uptime> {
        private long start;
        private long now;
        private long elapsed;

        public Builder withStart(long start) {
            this.start = start;
            return this;
        }

        public Builder withNow(long now) {
            this.now = now;
            return this;
        }

        public Builder withElapsed(long elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public Uptime build() {
            return Builder.validate(new Uptime(this));
        }

        private static Uptime validate(Uptime instance) {
            Precondition.checkMin(instance.now, instance.start, "now");
            Precondition.checkEquals(instance.elapsed, instance.now - instance.start, "elapsed");
            return instance;
        }
    }
}

