/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.kuali.common.jute.reflect.Reflection;
import org.kuali.common.jute.system.RuntimeEnvironment;
import org.kuali.common.jute.system.SystemFiles;
import org.kuali.common.jute.system.VirtualMachine;

@JsonDeserialize(builder=Builder.class)
public final class Java {
    private final File home;
    private final File tmpDir;
    private final String classVersion;
    private final ImmutableList<File> classPaths;
    private final ImmutableList<File> libraryPaths;
    private final ImmutableList<File> extensionDirs;
    private final RuntimeEnvironment runtime;
    private final VirtualMachine vm;

    private Java(Builder builder) {
        this.home = builder.home;
        this.tmpDir = builder.tmpDir;
        this.classVersion = builder.classVersion;
        this.classPaths = ImmutableList.copyOf((Collection)builder.classPaths);
        this.libraryPaths = ImmutableList.copyOf((Collection)builder.libraryPaths);
        this.extensionDirs = ImmutableList.copyOf((Collection)builder.extensionDirs);
        this.runtime = builder.runtime;
        this.vm = builder.vm;
    }

    public static Java build() {
        Builder builder = Java.builder();
        builder.withHome(new File(StandardSystemProperty.JAVA_HOME.value()));
        builder.withTmpDir(new File(StandardSystemProperty.JAVA_IO_TMPDIR.value()));
        builder.withClassVersion(StandardSystemProperty.JAVA_CLASS_VERSION.value());
        builder.withClassPaths(SystemFiles.fromSystemProperty(StandardSystemProperty.JAVA_CLASS_PATH));
        builder.withExtensionDirs(SystemFiles.fromSystemProperty(StandardSystemProperty.JAVA_EXT_DIRS));
        builder.withLibraryPaths(SystemFiles.fromSystemProperty(StandardSystemProperty.JAVA_LIBRARY_PATH));
        builder.withRuntime(RuntimeEnvironment.build());
        builder.withVm(VirtualMachine.build());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public File getHome() {
        return this.home;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public List<File> getClassPaths() {
        return this.classPaths;
    }

    public List<File> getLibraryPaths() {
        return this.libraryPaths;
    }

    public List<File> getExtensionDirs() {
        return this.extensionDirs;
    }

    public RuntimeEnvironment getRuntime() {
        return this.runtime;
    }

    public VirtualMachine getVm() {
        return this.vm;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<Java> {
        private File home;
        private File tmpDir;
        private String classVersion;
        private List<File> classPaths;
        private List<File> libraryPaths;
        private List<File> extensionDirs;
        private RuntimeEnvironment runtime;
        private VirtualMachine vm;

        public Builder withHome(File home) {
            this.home = home;
            return this;
        }

        public Builder withTmpDir(File tmpDir) {
            this.tmpDir = tmpDir;
            return this;
        }

        public Builder withClassVersion(String classVersion) {
            this.classVersion = classVersion;
            return this;
        }

        public Builder withClassPaths(List<File> classPaths) {
            this.classPaths = classPaths;
            return this;
        }

        public Builder withLibraryPaths(List<File> libraryPaths) {
            this.libraryPaths = libraryPaths;
            return this;
        }

        public Builder withExtensionDirs(List<File> extensionDirs) {
            this.extensionDirs = extensionDirs;
            return this;
        }

        public Builder withRuntime(RuntimeEnvironment runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder withVm(VirtualMachine vm) {
            this.vm = vm;
            return this;
        }

        public Java build() {
            return Reflection.checkNoNulls(new Java(this));
        }
    }
}

