/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import org.kuali.common.jute.reflect.Reflection;
import org.kuali.common.jute.system.Specification;

@JsonDeserialize(builder=Builder.class)
public final class RuntimeEnvironment {
    private final String vendor;
    private final String version;
    private final String vendorUrl;
    private final Specification specification;

    private RuntimeEnvironment(Builder builder) {
        this.specification = builder.specification;
        this.vendor = builder.vendor;
        this.version = builder.version;
        this.vendorUrl = builder.vendorUrl;
    }

    public static RuntimeEnvironment build() {
        Builder builder = RuntimeEnvironment.builder();
        builder.withVendor(StandardSystemProperty.JAVA_VENDOR.value());
        builder.withVersion(StandardSystemProperty.JAVA_VERSION.value());
        builder.withVendorUrl(StandardSystemProperty.JAVA_VENDOR_URL.value());
        builder.withSpecification(Specification.buildRuntimeEnvironmentSpecification());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendorUrl() {
        return this.vendorUrl;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<RuntimeEnvironment> {
        private String version;
        private String vendor;
        private String vendorUrl;
        private Specification specification;

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withVendorUrl(String vendorUrl) {
            this.vendorUrl = vendorUrl;
            return this;
        }

        public Builder withSpecification(Specification specification) {
            this.specification = specification;
            return this;
        }

        public RuntimeEnvironment build() {
            return Reflection.checkNoNulls(new RuntimeEnvironment(this));
        }
    }
}

