/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import java.io.File;
import org.kuali.common.jute.reflect.Reflection;

@JsonDeserialize(builder=Builder.class)
public final class User {
    private final String name;
    private final File home;
    private final File dir;

    private User(Builder builder) {
        this.name = builder.name;
        this.home = builder.home;
        this.dir = builder.dir;
    }

    public static User build() {
        Builder builder = User.builder();
        builder.withName(StandardSystemProperty.USER_NAME.value());
        builder.withHome(new File(StandardSystemProperty.USER_HOME.value()));
        builder.withDir(new File(StandardSystemProperty.USER_DIR.value()));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public File getHome() {
        return this.home;
    }

    public File getDir() {
        return this.dir;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<User> {
        private String name;
        private File home;
        private File dir;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withHome(File home) {
            this.home = home;
            return this;
        }

        public Builder withDir(File dir) {
            this.dir = dir;
            return this;
        }

        public User build() {
            return Reflection.checkNoNulls(new User(this));
        }
    }
}

