/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jute.system;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.StandardSystemProperty;
import org.kuali.common.jute.reflect.Reflection;
import org.kuali.common.jute.system.Specification;

@JsonDeserialize(builder=Builder.class)
public final class VirtualMachine {
    private final String name;
    private final String version;
    private final String vendor;
    private final Specification specification;

    private VirtualMachine(Builder builder) {
        this.name = builder.name;
        this.vendor = builder.vendor;
        this.version = builder.version;
        this.specification = builder.specification;
    }

    public static VirtualMachine build() {
        Builder builder = VirtualMachine.builder();
        builder.withName(StandardSystemProperty.JAVA_VM_NAME.value());
        builder.withVendor(StandardSystemProperty.JAVA_VM_VENDOR.value());
        builder.withVersion(StandardSystemProperty.JAVA_VM_VERSION.value());
        builder.withSpecification(Specification.buildVirtualMachineSpecification());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<VirtualMachine> {
        private String name;
        private String version;
        private String vendor;
        private Specification specification;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withSpecification(Specification specification) {
            this.specification = specification;
            return this;
        }

        public VirtualMachine build() {
            return Reflection.checkNoNulls(new VirtualMachine(this));
        }
    }
}

