/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.common.PropertiesUtils;

public class Extractor {
    PropertiesUtils utils = new PropertiesUtils();

    public void handleSVNBranch(AbstractMojo mojo, MavenProject project, String property) {
        String scmUrl;
        String branch;
        String scmType = this.getScmType(project.getScm());
        if (!"svn".equalsIgnoreCase(scmType)) {
            mojo.getLog().warn((CharSequence)"This should only be used with Subversion");
        }
        if (!StringUtils.isEmpty((String)(branch = this.getBranch(scmUrl = this.getScmUrl(project.getScm()))))) {
            project.getProperties().setProperty(property, branch);
            mojo.getLog().info((CharSequence)(property + "=" + branch));
        } else {
            mojo.getLog().debug((CharSequence)"SVN branch could not be determined");
        }
    }

    public void handleSVNTagBase(AbstractMojo mojo, MavenProject project, String property) {
        String scmUrl;
        String tagBase;
        String scmType = this.getScmType(project.getScm());
        if (!"svn".equalsIgnoreCase(scmType)) {
            mojo.getLog().warn((CharSequence)"This should only be used with Subversion");
        }
        if (!StringUtils.isEmpty((String)(tagBase = this.getTagBase(scmUrl = this.getScmUrl(project.getScm()))))) {
            project.getProperties().setProperty(property, tagBase);
            mojo.getLog().info((CharSequence)(property + "=" + tagBase));
        } else {
            mojo.getLog().debug((CharSequence)"SVN tag base could not be determined");
        }
    }

    public void handleMajorVersion(AbstractMojo mojo, MavenProject project, String property) {
        String majorVersion = this.getMajorVersion(project.getVersion());
        if (!StringUtils.isEmpty((String)majorVersion)) {
            project.getProperties().setProperty(property, majorVersion);
            mojo.getLog().info((CharSequence)(property + "=" + majorVersion));
        } else {
            mojo.getLog().info((CharSequence)"Major version could not be determined");
        }
    }

    public void handleScmUrl(AbstractMojo mojo, MavenProject project, String property) {
        String scmUrl = this.getScmUrl(project.getScm());
        if (!StringUtils.isEmpty((String)scmUrl)) {
            project.getProperties().setProperty(property, scmUrl);
            mojo.getLog().info((CharSequence)(property + "=" + scmUrl));
        } else {
            mojo.getLog().info((CharSequence)"scm url could not be determined");
        }
    }

    public void handleScmType(AbstractMojo mojo, MavenProject project, String property) {
        String scmType = this.getScmType(project.getScm());
        if (!StringUtils.isEmpty((String)scmType)) {
            project.getProperties().setProperty(property, scmType);
            mojo.getLog().info((CharSequence)(property + "=" + scmType));
        } else {
            mojo.getLog().info((CharSequence)"scm type could not be determined");
        }
    }

    public String getActualUrl(MavenProject project, String property) throws MojoExecutionException {
        Properties props = this.utils.getMavenProperties(project);
        String rawUrl = props.getProperty(property);
        if (StringUtils.isBlank((String)rawUrl)) {
            throw new MojoExecutionException("The project property '" + property + "' is blank");
        }
        String resolvedValue = this.utils.getResolvedValue(rawUrl, props);
        if (StringUtils.isBlank((String)resolvedValue)) {
            throw new MojoExecutionException("Resolved value for '" + property + "' is blank");
        }
        return resolvedValue;
    }

    public Scm getTrimmedScm(Scm scm) {
        String trimmedDeveloperConnection = this.getTrimmedScmUrl(scm.getDeveloperConnection());
        String trimmedConnection = this.getTrimmedScmUrl(scm.getConnection());
        String trimmedUrl = scm.getUrl().trim();
        Scm trimmedScm = new Scm();
        trimmedScm.setDeveloperConnection(trimmedDeveloperConnection);
        trimmedScm.setConnection(trimmedConnection);
        trimmedScm.setUrl(trimmedUrl);
        return trimmedScm;
    }

    public String getScmUrl(Scm scm) {
        String scmUrl;
        String devCon = scm.getDeveloperConnection();
        String con = scm.getConnection();
        String string = scmUrl = StringUtils.isEmpty((String)devCon) ? con : devCon;
        if (StringUtils.isEmpty((String)scmUrl)) {
            return null;
        }
        return this.getTrimmedScmUrl(scmUrl);
    }

    protected String getTrimmedScmUrl(String url) {
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)url.trim(), (String)":");
        if (tokens == null || tokens.length < 3) {
            throw new IllegalArgumentException("Unable to trim url " + url);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < tokens.length; ++i) {
            if (i != 2) {
                sb.append(":");
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public String getScmType(Scm scm) {
        String scmType1 = this.getScmType(scm.getDeveloperConnection());
        String scmType2 = this.getScmType(scm.getConnection());
        if (!StringUtils.isEmpty((String)scmType1)) {
            return scmType1;
        }
        if (!StringUtils.isEmpty((String)scmType2)) {
            return scmType2;
        }
        return null;
    }

    public String getScmType(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)url, (String)":");
        if (tokens == null || tokens.length < 2) {
            return null;
        }
        return tokens[1];
    }

    public String getBranch(String url) {
        int pos = url.lastIndexOf("/trunk");
        if (pos != -1) {
            return "trunk";
        }
        String token = "/branches/";
        pos = url.lastIndexOf(token);
        if (pos == -1) {
            return null;
        }
        String s = url.substring(pos + token.length());
        if ((pos = s.indexOf("/")) == -1) {
            return s;
        }
        return s.substring(0, pos);
    }

    public void validateTrimmedScm(Scm scm, String actualUrl) {
        this.validateUrls(scm.getDeveloperConnection(), actualUrl);
        this.validateUrls(scm.getConnection(), actualUrl);
        this.validateUrls(scm.getUrl(), actualUrl);
    }

    public void validateUrls(String url, String actualUrl) {
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("url cannot be blank");
        }
        if (StringUtils.isBlank((String)actualUrl)) {
            throw new IllegalArgumentException("actualUrl cannot be blank");
        }
        if (!url.equals(actualUrl)) {
            throw new IllegalArgumentException("URL's don't match. url=[" + url + "] actual=[" + actualUrl);
        }
    }

    public String getTagBase(String url) {
        int pos2;
        int pos1 = url.lastIndexOf("/branches");
        int pos = Math.max(pos1, pos2 = url.lastIndexOf("/trunk"));
        if (pos == -1) {
            return null;
        }
        return url.substring(0, pos) + "/tags";
    }

    public String getMajorVersion(String version) {
        if (StringUtils.isEmpty((String)version)) {
            return null;
        }
        int pos = this.getPos(version);
        if (pos == -1) {
            return version;
        }
        int peekAhead = this.peekAhead(pos, version);
        return version.substring(0, peekAhead);
    }

    protected int peekAhead(int pos, String version) {
        int index = pos + 1;
        if (index >= version.length()) {
            return pos;
        }
        char c = version.charAt(index);
        if (this.isInteger(c)) {
            return index + 1;
        }
        return pos;
    }

    protected int getPos(String version) {
        int pos2;
        int pos1 = version.indexOf(".");
        if (pos1 == (pos2 = version.indexOf("-")) && pos2 == -1) {
            return -1;
        }
        if (pos1 == -1 && pos2 != -1) {
            return pos2;
        }
        if (pos1 != -1 && pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    protected boolean isInteger(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

