/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceUtils {
    ResourceLoader loader = new DefaultResourceLoader();

    public InputStream getInputStream(String location) throws IOException {
        if (!this.exists(location)) {
            throw new IOException("Unable to locate " + location);
        }
        File file = new File(location);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        Resource resource = this.loader.getResource(location);
        return resource.getInputStream();
    }

    public boolean exists(String location) {
        File file = new File(location);
        if (file.exists()) {
            return true;
        }
        Resource resource = this.loader.getResource(location);
        return resource.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String location, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = this.getInputStream(location);
            out = FileUtils.openOutputStream((File)file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String contents) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            IOUtils.write((String)contents, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public List<String> read(List<String> locations) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        for (String location : locations) {
            String content = this.read(location);
            contents.add(content);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String location) throws IOException {
        InputStream in = null;
        try {
            in = this.getInputStream(location);
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public String getFilename(String location) throws IOException {
        if (!this.exists(location)) {
            throw new IOException("Unable to locate " + location);
        }
        File file = new File(location);
        if (file.exists()) {
            return file.getName();
        }
        Resource resource = this.loader.getResource(location);
        return resource.getFilename();
    }
}

