/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.kuali.maven.mojo.s3.ColumnDecorator;
import org.kuali.maven.mojo.s3.HtmlUtils;
import org.kuali.maven.mojo.s3.S3BucketContext;
import org.kuali.maven.mojo.s3.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontHtmlGenerator {
    HtmlUtils html = new HtmlUtils();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    S3BucketContext context;

    public CloudFrontHtmlGenerator() {
        this(null);
    }

    public CloudFrontHtmlGenerator(S3BucketContext context) {
        this.context = context;
    }

    protected List<ColumnDecorator> getColumnDecorators() {
        ArrayList<ColumnDecorator> columnDecorators = new ArrayList<ColumnDecorator>();
        columnDecorators.add(new ColumnDecorator("image-column", "sort-header", ""));
        columnDecorators.add(new ColumnDecorator("name-column", "sort-header", "Name"));
        columnDecorators.add(new ColumnDecorator("last-modified-column", "sort-header", "Last Modified"));
        columnDecorators.add(new ColumnDecorator("size-column", "sort-header", "Size"));
        return columnDecorators;
    }

    protected String getDirectory(String prefix, String delimiter) {
        if (prefix == null) {
            return delimiter;
        }
        if (prefix.endsWith(delimiter)) {
            return delimiter + prefix.substring(0, prefix.length() - delimiter.length());
        }
        return delimiter + prefix;
    }

    protected String getHtmlComment() {
        return "<!-- Generated on " + this.sdf.format(new Date()) + " -->\n";
    }

    protected String getDocType() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
    }

    protected String getMeta() {
        return "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n";
    }

    protected String getGoogleAnalyticsJavascript() {
        return "<script type=\"text/javascript\">var _gaq = _gaq || []; _gaq.push(['_setAccount', 'UA-16781661-1']); _gaq.push(['_setDomainName', '.kuali.org']); _gaq.push(['_trackPageview']); (function() { var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true; ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js'; var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s); })();</script>\n";
    }

    public String getHtml(List<String[]> data, String prefix, String delimiter) {
        String directory = this.getDirectory(prefix, delimiter);
        Tag html = new Tag("html");
        Tag title = new Tag("title");
        Tag head = new Tag("head");
        Tag body = new Tag("body");
        Tag div1 = new Tag("div", "title");
        Tag span1 = new Tag("span", null, "title");
        Tag div2 = new Tag("div", "data");
        Tag div3 = new Tag("div", "footer", "footer-left");
        Tag span2 = new Tag("span", null, "footer-text");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocType());
        sb.append(this.html.openTag(html));
        sb.append(this.html.getIndentedContent(this.getHtmlComment()));
        sb.append(this.html.getTag(title, "Directory listing for " + directory));
        sb.append(this.html.openTag(head));
        sb.append(this.html.getIndentedContent("<link href=\"" + this.context.getCss() + "\" rel=\"stylesheet\" type=\"text/css\"/>\n"));
        sb.append(this.html.getIndentedContent(this.getMeta()));
        sb.append(this.html.getIndentedContent(this.getGoogleAnalyticsJavascript()));
        sb.append(this.html.closeTag(head));
        sb.append(this.html.openTag(body));
        sb.append(this.html.openTag(div1));
        sb.append(this.html.getTag(span1, "Directory listing for " + directory));
        sb.append(this.html.closeTag(div1));
        sb.append(this.html.getIndentedContent("<hr>\n"));
        sb.append(this.html.openTag(div2));
        sb.append(this.getHtmlTable(data, this.getColumnDecorators()));
        sb.append(this.html.closeTag(div2));
        sb.append(this.html.getIndentedContent("<hr>\n"));
        sb.append(this.html.openTag(div3));
        sb.append(this.html.getTag(span2, this.context.getAbout()));
        sb.append(this.html.closeTag(div3));
        sb.append(this.html.closeTag(body));
        sb.append(this.html.closeTag(html));
        return sb.toString();
    }

    protected String getTableCell(String content, ColumnDecorator decorator) {
        Tag td = new Tag("td", decorator.getTableDataClass());
        return this.html.getTag(td, content);
    }

    protected boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    protected Tag getTableRowTag(int row) {
        if (row % 2 == 0) {
            return new Tag("tr", "table-tr-odd");
        }
        return new Tag("tr");
    }

    protected String getTableRow(int row, String[] data, List<ColumnDecorator> columnDecorators) {
        StringBuffer sb = new StringBuffer();
        Tag tr = this.getTableRowTag(row);
        sb.append(this.html.openTag(tr));
        for (int i = 0; i < data.length; ++i) {
            sb.append(this.getTableCell(data[i], columnDecorators.get(i)));
        }
        sb.append(this.html.closeTag(tr));
        return sb.toString();
    }

    protected String getTableRows(List<String[]> data, List<ColumnDecorator> columnDecorators) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.size(); ++i) {
            sb.append(this.getTableRow(i, data.get(i), columnDecorators));
        }
        return sb.toString();
    }

    protected String getTableHeaders(List<ColumnDecorator> columnDecorators) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columnDecorators.size(); ++i) {
            ColumnDecorator decorator = columnDecorators.get(i);
            Tag th = new Tag("th", decorator.getTableDataClass());
            sb.append(this.html.openTag(th));
            sb.append(this.html.getTag(new Tag("span", decorator.getSpanClass()), decorator.getColumnTitle()));
            sb.append(this.html.closeTag(th));
        }
        return sb.toString();
    }

    protected String getHtmlTable(List<String[]> data, List<ColumnDecorator> columnDecorators) {
        if (this.isEmpty(data)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Tag table = new Tag("table", "mainTable");
        Tag thead = new Tag("thead");
        Tag tr = new Tag("tr");
        Tag tbody = new Tag("tbody");
        sb.append(this.html.openTag(table));
        sb.append(this.html.openTag(thead));
        sb.append(this.html.openTag(tr));
        sb.append(this.getTableHeaders(columnDecorators));
        sb.append(this.html.closeTag(tr));
        sb.append(this.html.closeTag(thead));
        sb.append(this.html.openTag(tbody));
        sb.append(this.getTableRows(data, columnDecorators));
        sb.append(this.html.closeTag(tbody));
        sb.append(this.html.closeTag(table));
        return sb.toString();
    }

    public S3BucketContext getContext() {
        return this.context;
    }

    public void setContext(S3BucketContext context) {
        this.context = context;
    }
}

