/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;

public class SimpleFormatter {
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final double ONE_SECOND = 1000.0;
    private static final double ONE_MINUTE = 60000.0;
    private static final double FIFTEEN_MINUTES = 900000.0;
    NumberFormat sizeFormatter = NumberFormat.getInstance();
    NumberFormat timeFormatter = NumberFormat.getInstance();
    NumberFormat rateFormatter = NumberFormat.getInstance();

    public SimpleFormatter() {
        this.sizeFormatter.setGroupingUsed(false);
        this.sizeFormatter.setMaximumFractionDigits(1);
        this.sizeFormatter.setMinimumFractionDigits(1);
        this.timeFormatter.setGroupingUsed(false);
        this.timeFormatter.setMaximumFractionDigits(3);
        this.timeFormatter.setMinimumFractionDigits(3);
        this.rateFormatter.setGroupingUsed(false);
        this.rateFormatter.setMaximumFractionDigits(1);
        this.rateFormatter.setMinimumFractionDigits(1);
    }

    public String getRate(long millis, long bytes) {
        int pad = 1;
        double kilobytes = (double)bytes / 1024.0;
        double seconds = (double)millis / 1000.0;
        double kilobytesPerSecond = kilobytes / seconds;
        if (kilobytesPerSecond < 1024.0) {
            return StringUtils.leftPad((String)(this.rateFormatter.format(kilobytesPerSecond) + " kB/s"), (int)pad, (String)" ");
        }
        double transferRate = kilobytesPerSecond / 1024.0;
        return StringUtils.leftPad((String)(this.rateFormatter.format(transferRate) + " MB/s"), (int)pad, (String)" ");
    }

    public String getTime(long millis) {
        int pad = 1;
        if ((double)millis < 1000.0) {
            return StringUtils.leftPad((String)(millis + "ms"), (int)pad, (String)" ");
        }
        if ((double)millis < 10000.0) {
            return StringUtils.leftPad((String)(this.timeFormatter.format((double)millis / 1000.0) + "s"), (int)pad, (String)" ");
        }
        if ((double)millis < 900000.0) {
            return StringUtils.leftPad((String)(this.rateFormatter.format((double)millis / 1000.0) + "s"), (int)pad, (String)" ");
        }
        return StringUtils.leftPad((String)(this.rateFormatter.format((double)millis / 60000.0) + "m"), (int)pad, (String)" ");
    }

    public String getSize(long bytes) {
        int pad = 1;
        if ((double)bytes < 1048576.0) {
            return StringUtils.leftPad((String)(this.sizeFormatter.format((double)bytes / 1024.0) + "k"), (int)pad, (String)" ");
        }
        if ((double)bytes < 1.073741824E9) {
            return StringUtils.leftPad((String)(this.sizeFormatter.format((double)bytes / 1048576.0) + "m"), (int)pad, (String)" ");
        }
        return StringUtils.leftPad((String)(this.sizeFormatter.format((double)bytes / 1.073741824E9) + "g"), (int)pad, (String)" ");
    }
}

