/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import com.amazonaws.AmazonServiceException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ListIteratorContext;
import org.kuali.maven.mojo.s3.ListObjectsContextHandler;
import org.kuali.maven.mojo.s3.S3PrefixContext;
import org.kuali.maven.mojo.s3.UpdateDirectoryContext;
import org.kuali.maven.mojo.s3.UpdateOriginBucketMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDirectoryContextHandler
implements ElementHandler<UpdateDirectoryContext> {
    private final Logger logger = LoggerFactory.getLogger(ListObjectsContextHandler.class);
    UpdateOriginBucketMojo mojo;

    public UpdateDirectoryContextHandler() {
        this(null);
    }

    public UpdateDirectoryContextHandler(UpdateOriginBucketMojo mojo) {
        this.mojo = mojo;
    }

    public void handleElement(ListIteratorContext<UpdateDirectoryContext> context, int index, UpdateDirectoryContext element) {
        this.logger.debug("[Thread:" + this.lpad(context.getId()) + ", Element:" + this.lpad(index) + "] " + element.getCopyToKey());
        try {
            S3PrefixContext prefixContext = element.getContext();
            if (prefixContext.isRoot()) {
                this.mojo.updateRoot(element);
            } else {
                this.mojo.updateDirectory(element);
            }
        }
        catch (IOException e) {
            throw new AmazonServiceException("Unexpected error:", (Exception)e);
        }
    }

    protected String lpad(int i) {
        return StringUtils.leftPad((String)(i + ""), (int)3, (String)" ");
    }

    public UpdateOriginBucketMojo getMojo() {
        return this.mojo;
    }

    public void setMojo(UpdateOriginBucketMojo mojo) {
        this.mojo = mojo;
    }
}

