/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.impl.parameter.AlwaysSucceedParameterEvaluatorImpl;
import org.kuali.rice.core.impl.parameter.ParameterEvaluatorImpl;
import org.kuali.rice.coreservice.api.parameter.EvaluationOperator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class ParameterEvaluatorServiceImpl
implements ParameterEvaluatorService {
    private ParameterService parameterService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterEvaluator getParameterEvaluator(Class componentClass, String parameterName) {
        return this.getParameterEvaluator(this.parameterService.getParameter(componentClass, parameterName));
    }

    @Override
    public ParameterEvaluator getParameterEvaluator(String namespaceCode, String detailTypeCode, String parameterName) {
        return this.getParameterEvaluator(this.parameterService.getParameter(namespaceCode, detailTypeCode, parameterName));
    }

    public ParameterEvaluator getParameterEvaluator(Class componentClass, String parameterName, String constrainedValue) {
        return this.getParameterEvaluator(this.parameterService.getParameter(componentClass, parameterName), constrainedValue);
    }

    @Override
    public ParameterEvaluator getParameterEvaluator(String namespaceCode, String detailTypeCode, String parameterName, String constrainedValue) {
        return this.getParameterEvaluator(this.parameterService.getParameter(namespaceCode, detailTypeCode, parameterName), constrainedValue);
    }

    public ParameterEvaluator getParameterEvaluator(Class componentClass, String parameterName, String constrainingValue, String constrainedValue) {
        return this.getParameterEvaluator(this.parameterService.getParameter(componentClass, parameterName), constrainingValue, constrainedValue);
    }

    public ParameterEvaluator getParameterEvaluator(Class componentClass, String allowParameterName, String denyParameterName, String constrainingValue, String constrainedValue) {
        Parameter allowParameter = this.parameterService.getParameter(componentClass, allowParameterName);
        Parameter denyParameter = this.parameterService.getParameter(componentClass, denyParameterName);
        if (!this.getParameterValues(allowParameter, constrainingValue).isEmpty() && !this.getParameterValues(denyParameter, constrainingValue).isEmpty()) {
            throw new IllegalArgumentException("The getParameterEvaluator(Class componentClass, String allowParameterName, String denyParameterName, String constrainingValue, String constrainedValue) method of ParameterServiceImpl does not facilitate evaluation of combination allow and deny parameters that both have values for the constraining value: " + allowParameterName + " / " + denyParameterName + " / " + constrainingValue);
        }
        if (this.getParameterValues(allowParameter, constrainingValue).isEmpty() && this.getParameterValues(denyParameter, constrainingValue).isEmpty()) {
            return AlwaysSucceedParameterEvaluatorImpl.getInstance();
        }
        return this.getParameterEvaluator(this.getParameterValues(denyParameter, constrainingValue).isEmpty() ? allowParameter : denyParameter, constrainingValue, constrainedValue);
    }

    protected List<String> getParameterValues(Parameter parameter, String constrainingValue) {
        List<String> constraintValuePairs = this.getParameterValues(parameter);
        for (String pair : constraintValuePairs) {
            if (!StringUtils.equals((String)constrainingValue, (String)StringUtils.substringBefore((String)pair, (String)"="))) continue;
            return Arrays.asList(StringUtils.substringAfter((String)pair, (String)"=").split(","));
        }
        return Collections.emptyList();
    }

    private List<String> getParameterValues(Parameter parameter) {
        if (parameter == null || StringUtils.isBlank((String)parameter.getValue())) {
            return Collections.emptyList();
        }
        return Arrays.asList(parameter.getValue().split(";"));
    }

    protected ParameterEvaluatorImpl getParameterEvaluator(Parameter parameter) {
        ParameterEvaluatorImpl parameterEvaluator = new ParameterEvaluatorImpl();
        parameterEvaluator.setParameter(parameter);
        parameterEvaluator.setConstraintIsAllow(this.constraintIsAllow(parameter));
        parameterEvaluator.setValues(this.getParameterValues(parameter));
        return parameterEvaluator;
    }

    protected ParameterEvaluatorImpl getParameterEvaluator(Parameter parameter, String constrainedValue) {
        ParameterEvaluatorImpl parameterEvaluator = this.getParameterEvaluator(parameter);
        parameterEvaluator.setConstrainedValue(constrainedValue);
        return parameterEvaluator;
    }

    protected ParameterEvaluatorImpl getParameterEvaluator(Parameter parameter, String constrainingValue, String constrainedValue) {
        ParameterEvaluatorImpl parameterEvaluator = this.getParameterEvaluator(parameter, constrainedValue);
        parameterEvaluator.setValues(this.getParameterValues(parameter, constrainingValue));
        return parameterEvaluator;
    }

    private boolean constraintIsAllow(Parameter parameter) {
        return EvaluationOperator.ALLOW.equals((Object)parameter.getEvaluationOperator());
    }
}

