/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.client.acegi;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.ticketvalidator.CasProxyTicketValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kim.client.acegi.KualiTicketResponse;
import org.kuali.rice.kim.sesn.DistributedSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class KualiCasProxyTicketValidator
extends CasProxyTicketValidator {
    private static final Log logger = LogFactory.getLog(KualiCasProxyTicketValidator.class);
    private DistributedSession distributedSession;

    protected TicketResponse validateNow(ProxyTicketValidator pv) throws AuthenticationServiceException, BadCredentialsException {
        String sAuthenticationSource = null;
        String sDST = null;
        try {
            pv.validate();
        }
        catch (Exception internalProxyTicketValidatorProblem) {
            throw new AuthenticationServiceException(internalProxyTicketValidatorProblem.getMessage());
        }
        if (!pv.isAuthenticationSuccesful()) {
            throw new BadCredentialsException(pv.getErrorCode() + ": " + pv.getErrorMessage());
        }
        logger.debug((Object)("PROXY RESPONSE: " + pv.getResponse()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"DEBUG");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(pv.getResponse()));
            Document doc = builder.parse(inStream);
            Element head = doc.getDocumentElement();
            NodeList attrs = head.getElementsByTagName("cas:attribute");
            for (int i = 0; i < attrs.getLength(); ++i) {
                logger.debug((Object)("Field name:" + ((Element)attrs.item(i)).getAttribute("name") + "=" + ((Element)attrs.item(i)).getAttribute("value")));
                if (((Element)attrs.item(i)).getAttribute("name").equals("authenticationMethod")) {
                    sAuthenticationSource = ((Element)attrs.item(i)).getAttribute("value");
                    continue;
                }
                if (!((Element)attrs.item(i)).getAttribute("name").equals("DST")) continue;
                sDST = ((Element)attrs.item(i)).getAttribute("value");
            }
            if (sAuthenticationSource != null && sDST != null) {
                String sPrincipal = pv.getUser() + "@" + sAuthenticationSource;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating session: " + sDST + " " + sPrincipal));
                }
                this.distributedSession.touchSesn(sDST);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Incomplete data from CAS:" + sAuthenticationSource + ":" + sDST));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing CAS Result", (Throwable)e);
        }
        logger.debug((Object)("Authentication Method:" + sAuthenticationSource));
        return new KualiTicketResponse(pv.getUser(), pv.getProxyList(), pv.getPgtIou(), sDST);
    }

    public void setDistributedSession(DistributedSession distributedSession) {
        this.distributedSession = distributedSession;
    }
}

