/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.client.acegi;

import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kim.client.acegi.KualiTicketResponse;
import org.kuali.rice.kim.client.acegi.KualiUserDetailsService;
import org.springframework.beans.factory.InitializingBean;

public class KualiUserDetailsServiceImpl
implements KualiUserDetailsService,
InitializingBean {
    private static final Log logger = LogFactory.getLog(KualiUserDetailsServiceImpl.class);

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public UserDetails loadUserByTicketResponse(KualiTicketResponse response) {
        GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(response.getDistributedSessionToken())};
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadUserByTicketResponse:" + response.getDistributedSessionToken()));
        }
        return this.loadUserByUsernameAndAuthorities(response.getUser(), authorities);
    }

    public UserDetails loadUserByUsername(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"loadUserByUsername");
        }
        return this.loadUserByUsernameAndAuthorities(username, new GrantedAuthority[0]);
    }

    public UserDetails loadUserByUsernameAndAuthorities(String username, GrantedAuthority[] authorities) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"loadUserByUsernameAndAuthorities");
        }
        GrantedAuthority[] newAuthorities = new GrantedAuthority[authorities.length + 1];
        System.arraycopy(authorities, 0, newAuthorities, 0, authorities.length);
        newAuthorities[authorities.length] = new GrantedAuthorityImpl("ROLE_KUALI_USER");
        logger.warn((Object)("setting granted authorities:" + newAuthorities.toString()));
        User user = new User(username, "empty_password", true, true, true, true, newAuthorities);
        return user;
    }
}

