/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import javax.xml.bind.UnmarshalException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.PermissionXmlDTO;

public final class PermissionXmlUtil {
    private PermissionXmlUtil() {
    }

    static void validateAndPersistNewPermission(PermissionXmlDTO newPermission) throws UnmarshalException {
        if (newPermission == null) {
            throw new IllegalArgumentException("Cannot persist a null permission");
        }
        PermissionXmlUtil.validatePermission(newPermission);
        Permission.Builder builder = Permission.Builder.create((String)newPermission.getNamespaceCode(), (String)newPermission.getPermissionName());
        builder.setDescription(newPermission.getPermissionDescription());
        builder.setActive(newPermission.getActive().booleanValue());
        builder.setAttributes(newPermission.getPermissionDetails());
        KimApiServiceLocator.getPermissionService().createPermission(builder.build());
    }

    private static void validatePermission(PermissionXmlDTO newPermission) throws UnmarshalException {
        if (StringUtils.isBlank((String)newPermission.getPermissionName()) || StringUtils.isBlank((String)newPermission.getNamespaceCode())) {
            throw new UnmarshalException("Cannot create a permission with a blank name or namespace");
        }
        if (StringUtils.isBlank((String)newPermission.getPermissionTemplateId())) {
            throw new UnmarshalException("Cannot create a permission without specifying a permission template");
        }
        if (StringUtils.isBlank((String)newPermission.getPermissionDescription())) {
            throw new UnmarshalException("Cannot create a permission with a blank description");
        }
        Permission permission = KimApiServiceLocator.getPermissionService().findPermByNamespaceCodeAndName(newPermission.getNamespaceCode(), newPermission.getPermissionName());
        if (permission != null) {
            newPermission.setPermissionId(permission.getId());
        }
    }
}

