/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePair;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePairValidatingAdapter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.jaxb.QualificationListAdapter;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.RoleMembersXmlDTO;

@XmlTransient
public abstract class RoleMemberXmlDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="principalId")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String principalId;
    @XmlElement(name="principalName")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String principalName;
    @XmlElement(name="groupId")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String groupId;
    @XmlElement(name="groupName")
    @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
    private NameAndNamespacePair groupName;
    @XmlElement(name="roleIdAsMember")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String roleIdAsMember;
    @XmlElement(name="roleNameAsMember")
    @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
    private NameAndNamespacePair roleNameAsMember;
    @XmlElement(name="activeFromDate")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private DateTime activeFromDate;
    @XmlElement(name="activeToDate")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private DateTime activeToDate;
    @XmlElement(name="qualifications")
    @XmlJavaTypeAdapter(value=QualificationListAdapter.class)
    private Map<String, String> qualifications;
    @XmlTransient
    private MemberType memberType;

    public RoleMemberXmlDTO() {
    }

    public RoleMemberXmlDTO(RoleMember roleMember, boolean populateMemberId) {
        if (roleMember == null) {
            throw new IllegalArgumentException("roleMember cannot be null");
        }
        this.memberType = roleMember.getType();
        this.activeFromDate = roleMember.getActiveFromDate();
        this.activeToDate = roleMember.getActiveToDate();
        Map map = this.qualifications = roleMember.getAttributes() != null ? roleMember.getAttributes() : new HashMap();
        if (MemberType.PRINCIPAL.equals((Object)this.memberType)) {
            Principal principal;
            if (populateMemberId) {
                this.principalId = roleMember.getMemberId();
            }
            if ((principal = KimApiServiceLocator.getIdentityService().getPrincipal(roleMember.getMemberId())) == null) {
                throw new IllegalArgumentException("Cannot find principal with ID \"" + roleMember.getMemberId() + "\"");
            }
            this.principalName = principal.getPrincipalName();
        } else if (MemberType.GROUP.equals((Object)this.memberType)) {
            Group group;
            if (populateMemberId) {
                this.groupId = roleMember.getMemberId();
            }
            if ((group = KimApiServiceLocator.getGroupService().getGroup(roleMember.getMemberId())) == null) {
                throw new IllegalArgumentException("Cannot find group with ID \"" + roleMember.getMemberId() + "\"");
            }
            this.groupName = new NameAndNamespacePair(group.getNamespaceCode(), group.getName());
        } else if (MemberType.ROLE.equals((Object)this.memberType)) {
            Role role;
            if (populateMemberId) {
                this.roleIdAsMember = roleMember.getMemberId();
            }
            if ((role = KimApiServiceLocator.getRoleService().getRole(roleMember.getMemberId())) == null) {
                throw new IllegalArgumentException("Cannot find role with ID \"" + roleMember.getMemberId() + "\"");
            }
            this.roleNameAsMember = new NameAndNamespacePair(role.getNamespaceCode(), role.getName());
        } else {
            throw new IllegalArgumentException("Cannot construct a RoleMemberXmlDTO from a role member with an unrecognized member type code of \"" + this.memberType + "\"");
        }
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public NameAndNamespacePair getGroupName() {
        return this.groupName;
    }

    public void setGroupName(NameAndNamespacePair groupName) {
        this.groupName = groupName;
    }

    public String getRoleIdAsMember() {
        return this.roleIdAsMember;
    }

    public void setRoleIdAsMember(String roleIdAsMember) {
        this.roleIdAsMember = roleIdAsMember;
    }

    public NameAndNamespacePair getRoleNameAsMember() {
        return this.roleNameAsMember;
    }

    public void setRoleNameAsMember(NameAndNamespacePair roleNameAsMember) {
        this.roleNameAsMember = roleNameAsMember;
    }

    public DateTime getActiveFromDate() {
        return this.activeFromDate;
    }

    public void setActiveFromDate(DateTime activeFromDate) {
        this.activeFromDate = activeFromDate;
    }

    public DateTime getActiveToDate() {
        return this.activeToDate;
    }

    public void setActiveToDate(DateTime activeToDate) {
        this.activeToDate = activeToDate;
    }

    public Map<String, String> getQualifications() {
        return this.qualifications;
    }

    public void setQualifications(Map<String, String> qualifications) {
        this.qualifications = qualifications;
    }

    public MemberType getMemberType() {
        if (this.memberType == null) {
            boolean foundMemberInfo = false;
            if (StringUtils.isNotBlank((String)this.principalId) || StringUtils.isNotBlank((String)this.principalName)) {
                this.memberType = MemberType.PRINCIPAL;
                foundMemberInfo = true;
            }
            if (StringUtils.isNotBlank((String)this.groupId) || this.groupName != null) {
                if (foundMemberInfo) {
                    this.memberType = null;
                    throw new IllegalStateException("Cannot have a role member that is simultaneously populated with member principal, member group, and/or member role information");
                }
                this.memberType = MemberType.GROUP;
                foundMemberInfo = true;
            }
            if (StringUtils.isNotBlank((String)this.roleIdAsMember) || this.roleNameAsMember != null) {
                if (foundMemberInfo) {
                    this.memberType = null;
                    throw new IllegalStateException("Cannot have a role member that is simultaneously populated with member principal, member group, and/or member role information");
                }
                this.memberType = MemberType.ROLE;
                boolean bl = true;
            }
        }
        return this.memberType;
    }

    public String getMemberId() {
        if (MemberType.PRINCIPAL.equals((Object)this.getMemberType())) {
            return this.principalId;
        }
        if (MemberType.GROUP.equals((Object)this.getMemberType())) {
            return this.groupId;
        }
        if (MemberType.ROLE.equals((Object)this.getMemberType())) {
            return this.roleIdAsMember;
        }
        return null;
    }

    public String getMemberName() {
        if (MemberType.PRINCIPAL.equals((Object)this.getMemberType())) {
            return this.principalName;
        }
        if (MemberType.GROUP.equals((Object)this.getMemberType())) {
            return this.groupName != null ? this.groupName.getName() : null;
        }
        if (MemberType.ROLE.equals((Object)this.getMemberType())) {
            return this.roleNameAsMember != null ? this.roleNameAsMember.getName() : null;
        }
        return null;
    }

    public String getMemberNamespaceCode() {
        if (MemberType.PRINCIPAL.equals((Object)this.getMemberType())) {
            return null;
        }
        if (MemberType.GROUP.equals((Object)this.getMemberType())) {
            return this.groupName != null ? this.groupName.getName() : null;
        }
        if (MemberType.ROLE.equals((Object)this.getMemberType())) {
            return this.roleNameAsMember != null ? this.roleNameAsMember.getName() : null;
        }
        return null;
    }

    public abstract String getRoleId();

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="RoleMemberType", propOrder={"principalId", "principalName", "groupId", "groupName", "roleIdAsMember", "roleNameAsMember", "activeFromDate", "activeToDate", "qualifications"})
    public static class WithinRole
    extends RoleMemberXmlDTO {
        private static final long serialVersionUID = 1L;
        @XmlTransient
        private String roleId;

        public WithinRole() {
        }

        public WithinRole(RoleMember roleMember, boolean populateMemberId) {
            super(roleMember, populateMemberId);
            this.roleId = roleMember.getRoleId();
        }

        void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
            if (parent instanceof RoleMembersXmlDTO.WithinRole) {
                this.roleId = ((RoleMembersXmlDTO.WithinRole)parent).getRoleId();
            }
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="StandaloneRoleMemberType", propOrder={"roleId", "roleNameAndNamespace", "principalId", "principalName", "groupId", "groupName", "roleIdAsMember", "roleNameAsMember", "activeFromDate", "activeToDate", "qualifications"})
    public static class OutsideOfRole
    extends RoleMemberXmlDTO {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="roleId")
        @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
        private String roleId;
        @XmlElement(name="roleName")
        @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
        private NameAndNamespacePair roleNameAndNamespace;

        public OutsideOfRole() {
        }

        public OutsideOfRole(RoleMember roleMember, boolean populateMemberId) {
            super(roleMember, populateMemberId);
            this.roleId = roleMember.getRoleId();
            Role tempRole = KimApiServiceLocator.getRoleService().getRole(this.roleId);
            if (tempRole == null) {
                throw new IllegalArgumentException("Cannot find role with ID \"" + this.roleId + "\"");
            }
            this.roleNameAndNamespace = new NameAndNamespacePair(tempRole.getNamespaceCode(), tempRole.getName());
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public NameAndNamespacePair getRoleNameAndNamespace() {
            return this.roleNameAndNamespace;
        }

        public void setRoleNameAndNamespace(NameAndNamespacePair roleNameAndNamespace) {
            this.roleNameAndNamespace = roleNameAndNamespace;
        }

        public String getRoleName() {
            return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getName() : null;
        }

        public String getRoleNamespaceCode() {
            return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getNamespaceCode() : null;
        }
    }
}

