/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.sesn;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kim.sesn.SessionIdGenerator;
import org.kuali.rice.kim.sesn.timeouthandlers.TimeoutHandler;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DistributedSession {
    public static final String DEFAULT_PREFIX = "DST";
    private static String prefix = "DST";
    private JdbcTemplate jdbcTemplate;
    private TimeoutHandler timeoutHandler;
    private boolean allowInsertOnTouch = false;
    private static final Log logger = LogFactory.getLog(DistributedSession.class);

    public void setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isSesnValid(String DST) {
        logger.debug((Object)"isSesnValid(DST)");
        return this.isSesnValid(DST, new HashMap<String, Object>());
    }

    public boolean isSesnValid(String DST, Map<String, Object> timeoutArgs) {
        boolean bRet;
        block7: {
            logger.debug((Object)"isSesnValid(DST, timeoutArgs)");
            bRet = false;
            String sql = "select sesnID, lastAccessDt, maxIdleTime from authnsesn where sesnID=?";
            if (DST != null) {
                Object[] args = new Object[]{DST};
                try {
                    Map fields = this.jdbcTemplate.queryForMap(sql, args);
                    fields.put("maxIdleTime", this.getMaxIdleTime((Long)fields.get("maxIdleTime"), (Date)fields.get("lastAccessDt")));
                    fields.putAll(timeoutArgs);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ARGUMENTS number:" + fields.size()));
                        for (Map.Entry entry : fields.entrySet()) {
                            logger.debug((Object)("ARGUMENT " + (String)entry.getKey() + ":" + entry.getValue()));
                        }
                    }
                    if (!this.timeoutHandler.hasTimedOut(fields)) {
                        logger.debug((Object)"Session not timed out");
                        bRet = true;
                        break block7;
                    }
                    logger.debug((Object)"Session timed out");
                }
                catch (Exception e) {
                    logger.debug((Object)e);
                }
            } else {
                logger.debug((Object)"Session ID is null");
            }
        }
        return bRet;
    }

    public List<String> getAuthenticatedPricipals(String DST) {
        String sql = "select principalID from authnsesn where sesnID=?";
        Object[] args = new Object[]{DST};
        return this.jdbcTemplate.queryForList(sql, args, String.class);
    }

    public void clearSesn(String DST) {
        String sql = "delete from authnsesn where sesnID='" + DST + "'";
        this.jdbcTemplate.execute(sql);
    }

    public String createSesn(String principalID) {
        String DST = this.generateDST();
        this.touchSesn(DST);
        this.addPrincipalToSesn(DST, principalID);
        return DST;
    }

    public String generateDST() {
        return prefix + "-" + SessionIdGenerator.getNewString();
    }

    public void touchSesn(String DST) {
        block4: {
            String sql = "select lastAccessDt, maxIdleTime from authnsesn where sesnID=?";
            String updateSql = "";
            Object[] args = new Object[]{DST};
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ARGUMENTS number:" + args.length));
                    logger.debug((Object)("ARGUMENTS 0:" + args[0]));
                }
                Map fields = this.jdbcTemplate.queryForMap(sql, args);
                Date lastAccessDt = (Date)fields.get("lastAccessDt");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Last Access:" + lastAccessDt));
                }
                Long maxIdleTime = this.getMaxIdleTime((Long)fields.get("maxIdleTime"), lastAccessDt);
                updateSql = "update authnsesn set lastAccessDt=NOW(), maxIdleTime = ? where sesnID=?";
                Object[] updateArgs = new Object[]{maxIdleTime, DST};
                this.jdbcTemplate.update(updateSql, updateArgs);
            }
            catch (IncorrectResultSizeDataAccessException ex) {
                if (!this.allowInsertOnTouch) break block4;
                Long maxIdleTime = new Long(0L);
                updateSql = "insert into authnsesn (sesnID, insertDt, lastAccessDt, maxIdleTime) values (?, NOW(), NOW(), ?)";
                Object[] updateArgs = new Object[]{DST, maxIdleTime};
                this.jdbcTemplate.update(updateSql, updateArgs);
            }
        }
    }

    public Long getMaxIdleTime(Long oldMaxIdleTime, Date lastAccessDt) {
        Long maxIdleTime = oldMaxIdleTime;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Max Idle:" + maxIdleTime));
        }
        long curIdleTime = System.currentTimeMillis() - lastAccessDt.getTime();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Curr Idle:" + curIdleTime));
        }
        if (curIdleTime > maxIdleTime) {
            maxIdleTime = new Long(curIdleTime);
        }
        return maxIdleTime;
    }

    public void addPrincipalToSesn(String DST, String principalID) {
        block3: {
            try {
                String updateSql = "insert into authnsesnprincipal (sesnID, principalID) values (?, ?)";
                this.jdbcTemplate.update(updateSql, new Object[]{DST, principalID});
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added Principal to Sesn:" + principalID + " " + DST));
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Principal Probably already exists:" + principalID + " " + DST));
            }
        }
    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String prefix) {
        DistributedSession.prefix = prefix;
    }

    public void setAllowInsertOnTouch(boolean allowInsertOnTouch) {
        this.allowInsertOnTouch = allowInsertOnTouch;
    }
}

