/*
 * Copyright (C) 2002-2003, Simon Nieuviarts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
package org.objectweb.carol.cmi;

/**
 * Classes which implement this interface are generated by the cluster stub
 * compiler to reflect the type of cluster stub. They can be found by calling
 * ClusterStub.getClusterConfig(), or
 * ClusterObject.getClusterConfig(java.lang.Class).
 * @author Simon Nieuviarts
 */
public interface ClusterConfig {
    /**
     * @return true if the object is clustered at export.
     */
    boolean isGlobalAtExport();

    /**
     * @return true if the object is clustered at bind.
     */
    boolean isGlobalAtBind();
}
