/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.EDLControllerChain;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kns.util.IncidentReportUtils;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthenticationException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EDLServlet
extends HttpServlet {
    private static final long serialVersionUID = -6344765194278430690L;
    private static final Logger LOG = Logger.getLogger(EDLServlet.class);

    public void init() throws ServletException {
        try {
            EdlServiceLocator.getEDocLiteService().initEDLGlobalConfig();
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing EDL", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String documentId = null;
        try {
            String edlName;
            UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
            if (userSession == null) {
                throw new AuthenticationException("Failed to locate a user session for request.");
            }
            GlobalVariables.setUserSession((UserSession)userSession);
            RequestParser requestParser = new RequestParser(request);
            String inputCommand = requestParser.getParameterValue("command");
            if (StringUtils.equals((String)inputCommand, (String)"initiate")) {
                requestParser.setParameterValue("userAction", "initiate");
            }
            if ((edlName = requestParser.getParameterValue("edlName")) == null) {
                edlName = requestParser.getParameterValue("docTypeName");
            }
            EDLController edlController = null;
            if (edlName == null) {
                documentId = requestParser.getParameterValue("docId");
                if (documentId == null) {
                    String docFormKey = requestParser.getParameterValue("docFormKey");
                    if (docFormKey != null) {
                        Document document = (Document)GlobalVariables.getUserSession().retrieveObject(docFormKey);
                        Element documentState = EDLXmlUtils.getDocumentStateElement(document);
                        documentId = EDLXmlUtils.getChildElementTextValue(documentState, "docId");
                        requestParser.setAttribute("docFormKey", docFormKey);
                    }
                    if (documentId == null) {
                        throw new WorkflowRuntimeException("No edl name or document id detected");
                    }
                }
                requestParser.setAttribute("docId", documentId);
                edlController = EdlServiceLocator.getEDocLiteService().getEDLControllerUsingDocumentId(documentId);
            } else {
                edlController = EdlServiceLocator.getEDocLiteService().getEDLControllerUsingEdlName(edlName);
            }
            if (inputCommand == null && requestParser.getParameterValue("docId") != null && !"POST".equals(request.getMethod()) && request.getParameterMap().size() <= 2) {
                requestParser.setParameterValue("command", "displayDocSearchView");
                LOG.info((Object)"command parameter was not passed with the request, and only document ID was. Defaulted command to 'displayDocSearchView' to ensure docContent remains.");
            }
            EDLControllerChain controllerChain = new EDLControllerChain();
            controllerChain.addEdlController(edlController);
            controllerChain.renderEDL(requestParser, response);
        }
        catch (Exception e) {
            LOG.error((Object)"Error processing EDL", (Throwable)e);
            this.outputError(request, response, e, documentId);
        }
        finally {
            GlobalVariables.setUserSession(null);
        }
    }

    private void outputError(HttpServletRequest request, HttpServletResponse response, Exception exception, String documentId) throws ServletException, IOException {
        IncidentReportUtils.populateRequestForIncidentReport((Exception)exception, (String)("" + documentId), (String)"eDoc Lite", (HttpServletRequest)request);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(request.getServletPath() + "/../../kr/kualiExceptionIncidentReport.do");
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }
}

