/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.components.VersioningPreprocessor;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectControlEDLComponent
implements EDLModelComponent {
    @Override
    public void updateDOM(Document dom, Element currentDefinitionElement, EDLContext edlContext) {
        Element currentVersion = VersioningPreprocessor.findCurrentVersion(dom);
        XPath xPath = XPathHelper.newXPath((Node)dom);
        try {
            NodeList selectFieldDefs = (NodeList)xPath.evaluate("//fieldDef[display/type = 'select' and display/valuesGroup] | //fieldDef[display/type = 'select_refresh' and display/valuesGroup]", dom, XPathConstants.NODESET);
            for (int fIndex = 0; fIndex < selectFieldDefs.getLength(); ++fIndex) {
                Element fieldDef = (Element)selectFieldDefs.item(fIndex);
                NodeList valuesGroups = (NodeList)xPath.evaluate("./display/valuesGroup", fieldDef, XPathConstants.NODESET);
                for (int index = 0; index < valuesGroups.getLength(); ++index) {
                    Element valuesGroupElem = (Element)valuesGroups.item(index);
                    NodeList dependsOnFields = (NodeList)xPath.evaluate("./dependsOn/field", valuesGroupElem, XPathConstants.NODESET);
                    String fieldEvalExpression = "";
                    for (int dIndex = 0; dIndex < dependsOnFields.getLength(); ++dIndex) {
                        if (!StringUtils.isBlank((String)fieldEvalExpression)) {
                            fieldEvalExpression = fieldEvalExpression + " and ";
                        }
                        Element fieldElem = (Element)dependsOnFields.item(dIndex);
                        String name = fieldElem.getAttribute("name");
                        String value = fieldElem.getTextContent();
                        fieldEvalExpression = fieldEvalExpression + "./field[@name='" + name + "']/value = '" + value + "'";
                    }
                    if (((Boolean)xPath.evaluate(fieldEvalExpression, currentVersion, XPathConstants.BOOLEAN)).booleanValue()) {
                        this.includeValuesGroup(valuesGroupElem);
                        continue;
                    }
                    valuesGroupElem.getParentNode().removeChild(valuesGroupElem);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to evaluate xpath expression.", e);
        }
    }

    protected void includeValuesGroup(Element valuesGroupElem) {
        Element valuesGroupParent = (Element)valuesGroupElem.getParentNode();
        NodeList valuesGroupChildren = valuesGroupElem.getChildNodes();
        for (int index = 0; index < valuesGroupChildren.getLength(); ++index) {
            Node item = valuesGroupChildren.item(index);
            if (1 != item.getNodeType() || !item.getNodeName().equals("values")) continue;
            valuesGroupParent.insertBefore(item, valuesGroupElem);
        }
        valuesGroupParent.removeChild(valuesGroupElem);
    }
}

