/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.edl.framework.extract.DumpDTO;
import org.kuali.rice.edl.framework.extract.FieldDTO;
import org.kuali.rice.edl.impl.extract.Fields;

@Entity
@Table(name="KREW_EDL_DMP_T")
public class Dump
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    @Id
    @Column(name="DOC_HDR_ID", nullable=false)
    private String docId;
    @Column(name="DOC_TYP_NM", nullable=false)
    private String docTypeName;
    @Column(name="DOC_HDR_STAT_CD", nullable=false)
    private String docRouteStatusCode;
    @Column(name="DOC_HDR_MDFN_DT", nullable=false)
    private Timestamp docModificationDate;
    @Column(name="DOC_HDR_CRTE_DT", nullable=false)
    private Timestamp docCreationDate;
    @Column(name="DOC_HDR_TTL")
    private String docDescription;
    @Column(name="DOC_HDR_INITR_PRNCPL_ID", nullable=false)
    private String docInitiatorId;
    @Column(name="CRNT_NODE_NM", nullable=false)
    private String docCurrentNodeName;
    @Version
    @Column(name="VER_NBR", nullable=false)
    private Integer lockVerNbr;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dump")
    private List<Fields> fields;
    static final long serialVersionUID = 227732889374745815L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Dump() {
        this.fields = new ArrayList<Fields>();
    }

    public Timestamp getDocCreationDate() {
        return this._persistence_get_docCreationDate();
    }

    public void setDocCreationDate(Timestamp docCreationDate) {
        this._persistence_set_docCreationDate(docCreationDate);
    }

    public String getDocCurrentNodeName() {
        return this._persistence_get_docCurrentNodeName();
    }

    public void setDocCurrentNodeName(String docCurrentNodeName) {
        this._persistence_set_docCurrentNodeName(docCurrentNodeName);
    }

    public String getDocDescription() {
        return this._persistence_get_docDescription();
    }

    public void setDocDescription(String docDescription) {
        this._persistence_set_docDescription(docDescription);
    }

    public String getDocId() {
        return this._persistence_get_docId();
    }

    public String getDocInitiatorId() {
        return this._persistence_get_docInitiatorId();
    }

    public void setDocInitiatorId(String docInitiatorId) {
        this._persistence_set_docInitiatorId(docInitiatorId);
    }

    public Timestamp getDocModificationDate() {
        return this._persistence_get_docModificationDate();
    }

    public void setDocModificationDate(Timestamp docModificationDate) {
        this._persistence_set_docModificationDate(docModificationDate);
    }

    public String getDocRouteStatusCode() {
        return this._persistence_get_docRouteStatusCode();
    }

    public void setDocRouteStatusCode(String docRouteStatusCode) {
        this._persistence_set_docRouteStatusCode(docRouteStatusCode);
    }

    public String getDocTypeName() {
        return this._persistence_get_docTypeName();
    }

    public void setDocTypeName(String docTypeName) {
        this._persistence_set_docTypeName(docTypeName);
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public String getFormattedCreateDateTime() {
        long time = this.getDocCreationDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        return dateFormat.format(date);
    }

    public String getFormattedCreateDate() {
        long time = this.getDocCreationDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        DateFormat dateFormat = RiceConstants.getDefaultDateFormat();
        return dateFormat.format(date);
    }

    public void setDocId(String docId) {
        this._persistence_set_docId(docId);
    }

    public List<Fields> getFields() {
        return this._persistence_get_fields();
    }

    public void setFields(List<Fields> fields) {
        this._persistence_set_fields(fields);
    }

    public static DumpDTO to(Dump dump) {
        if (dump == null) {
            return null;
        }
        DumpDTO dumpDTO = new DumpDTO();
        dumpDTO.setDocCreationDate(dump.getDocCreationDate());
        dumpDTO.setDocCurrentNodeName(dump.getDocCurrentNodeName());
        dumpDTO.setDocDescription(dump.getDocDescription());
        dumpDTO.setDocId(dump.getDocId());
        dumpDTO.setDocInitiatorId(dump.getDocInitiatorId());
        dumpDTO.setDocModificationDate(dump.getDocModificationDate());
        dumpDTO.setDocRouteStatusCode(dump.getDocRouteStatusCode());
        dumpDTO.setDocTypeName(dump.getDocTypeName());
        dumpDTO.setLockVerNbr(dump.getLockVerNbr());
        ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
        for (Fields field : dump.getFields()) {
            fields.add(Fields.to(field));
        }
        dumpDTO.setFields(fields);
        return dumpDTO;
    }

    public static Dump from(DumpDTO dumpDTO) {
        if (dumpDTO == null) {
            return null;
        }
        Dump dump = new Dump();
        dump.setDocCreationDate(dumpDTO.getDocCreationDate());
        dump.setDocCurrentNodeName(dumpDTO.getDocCurrentNodeName());
        dump.setDocDescription(dumpDTO.getDocDescription());
        dump.setDocId(dumpDTO.getDocId());
        dump.setDocInitiatorId(dumpDTO.getDocInitiatorId());
        dump.setDocModificationDate(dumpDTO.getDocModificationDate());
        dump.setDocRouteStatusCode(dumpDTO.getDocRouteStatusCode());
        dump.setDocTypeName(dumpDTO.getDocTypeName());
        dump.setLockVerNbr(dumpDTO.getLockVerNbr());
        ArrayList<Fields> fields = new ArrayList<Fields>();
        for (FieldDTO fieldDTO : dumpDTO.getFields()) {
            fields.add(Fields.from(fieldDTO, dump));
        }
        dump.setFields(fields);
        return dump;
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Dump(persistenceObject);
    }

    public Dump(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "docDescription") {
            return this.docDescription;
        }
        if (string == "docCurrentNodeName") {
            return this.docCurrentNodeName;
        }
        if (string == "docTypeName") {
            return this.docTypeName;
        }
        if (string == "docInitiatorId") {
            return this.docInitiatorId;
        }
        if (string == "docId") {
            return this.docId;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "docRouteStatusCode") {
            return this.docRouteStatusCode;
        }
        if (string == "fields") {
            return this.fields;
        }
        if (string == "docCreationDate") {
            return this.docCreationDate;
        }
        if (string == "docModificationDate") {
            return this.docModificationDate;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "docDescription") {
            this.docDescription = (String)object;
            return;
        }
        if (string == "docCurrentNodeName") {
            this.docCurrentNodeName = (String)object;
            return;
        }
        if (string == "docTypeName") {
            this.docTypeName = (String)object;
            return;
        }
        if (string == "docInitiatorId") {
            this.docInitiatorId = (String)object;
            return;
        }
        if (string == "docId") {
            this.docId = (String)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "docRouteStatusCode") {
            this.docRouteStatusCode = (String)object;
            return;
        }
        if (string == "fields") {
            this.fields = (List)object;
            return;
        }
        if (string == "docCreationDate") {
            this.docCreationDate = (Timestamp)object;
            return;
        }
        if (string == "docModificationDate") {
            this.docModificationDate = (Timestamp)object;
            return;
        }
    }

    public String _persistence_get_docDescription() {
        this._persistence_checkFetched("docDescription");
        return this.docDescription;
    }

    public void _persistence_set_docDescription(String string) {
        this._persistence_checkFetchedForSet("docDescription");
        this.docDescription = string;
    }

    public String _persistence_get_docCurrentNodeName() {
        this._persistence_checkFetched("docCurrentNodeName");
        return this.docCurrentNodeName;
    }

    public void _persistence_set_docCurrentNodeName(String string) {
        this._persistence_checkFetchedForSet("docCurrentNodeName");
        this.docCurrentNodeName = string;
    }

    public String _persistence_get_docTypeName() {
        this._persistence_checkFetched("docTypeName");
        return this.docTypeName;
    }

    public void _persistence_set_docTypeName(String string) {
        this._persistence_checkFetchedForSet("docTypeName");
        this.docTypeName = string;
    }

    public String _persistence_get_docInitiatorId() {
        this._persistence_checkFetched("docInitiatorId");
        return this.docInitiatorId;
    }

    public void _persistence_set_docInitiatorId(String string) {
        this._persistence_checkFetchedForSet("docInitiatorId");
        this.docInitiatorId = string;
    }

    public String _persistence_get_docId() {
        this._persistence_checkFetched("docId");
        return this.docId;
    }

    public void _persistence_set_docId(String string) {
        this._persistence_checkFetchedForSet("docId");
        this.docId = string;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this.lockVerNbr = n;
    }

    public String _persistence_get_docRouteStatusCode() {
        this._persistence_checkFetched("docRouteStatusCode");
        return this.docRouteStatusCode;
    }

    public void _persistence_set_docRouteStatusCode(String string) {
        this._persistence_checkFetchedForSet("docRouteStatusCode");
        this.docRouteStatusCode = string;
    }

    public List _persistence_get_fields() {
        this._persistence_checkFetched("fields");
        return this.fields;
    }

    public void _persistence_set_fields(List list) {
        this._persistence_checkFetchedForSet("fields");
        this.fields = list;
    }

    public Timestamp _persistence_get_docCreationDate() {
        this._persistence_checkFetched("docCreationDate");
        return this.docCreationDate;
    }

    public void _persistence_set_docCreationDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("docCreationDate");
        this.docCreationDate = timestamp;
    }

    public Timestamp _persistence_get_docModificationDate() {
        this._persistence_checkFetched("docModificationDate");
        return this.docModificationDate;
    }

    public void _persistence_set_docModificationDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("docModificationDate");
        this.docModificationDate = timestamp;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

