
# -----------------------------------------------------------------------
# BK_ADDRESS_T
# -----------------------------------------------------------------------
drop table if exists BK_ADDRESS_T
/

CREATE TABLE BK_ADDRESS_T
(
      ADDRESS_ID DECIMAL(22)
        , AUTHOR_ID DECIMAL(22)
        , ADDR_TYP VARCHAR(40)
        , STREET1 VARCHAR(50)
        , STREET2 VARCHAR(50)
        , CITY VARCHAR(50)
        , PROVIENCE VARCHAR(50)
        , COUNTRY VARCHAR(50)
        , ACTV_IND VARCHAR(1) default 'Y'
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_ADDRESS_TP1 PRIMARY KEY(ADDRESS_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_ADDRESS_TYP_T
# -----------------------------------------------------------------------
drop table if exists BK_ADDRESS_TYP_T
/

CREATE TABLE BK_ADDRESS_TYP_T
(
      ADDR_TYP VARCHAR(40)
        , DESC_TXT VARCHAR(255)
        , ACTV_IND VARCHAR(1) default 'Y'
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_ADDRESS_TYP_TP1 PRIMARY KEY(ADDR_TYP)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_AUTHOR_ACCOUNT_T
# -----------------------------------------------------------------------
drop table if exists BK_AUTHOR_ACCOUNT_T
/

CREATE TABLE BK_AUTHOR_ACCOUNT_T
(
      AUTHOR_ID DECIMAL(22)
        , ACCOUNT_NUMBER VARCHAR(50)
        , BANK_NAME VARCHAR(100)
    
    , CONSTRAINT BK_AUTHOR_ACCOUNT_TP1 PRIMARY KEY(AUTHOR_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_AUTHOR_T
# -----------------------------------------------------------------------
drop table if exists BK_AUTHOR_T
/

CREATE TABLE BK_AUTHOR_T
(
      AUTHOR_ID DECIMAL(22)
        , NM VARCHAR(100)
        , ADDRESS VARCHAR(200)
        , EMAIL VARCHAR(50)
        , PHONE_NBR VARCHAR(20)
        , ACTV_IND VARCHAR(1) default 'Y'
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_AUTHOR_TP1 PRIMARY KEY(AUTHOR_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_BOOK_AUTHOR_T
# -----------------------------------------------------------------------
drop table if exists BK_BOOK_AUTHOR_T
/

CREATE TABLE BK_BOOK_AUTHOR_T
(
      BOOK_ID DECIMAL(22)
        , AUTHOR_ID DECIMAL(22)
    
    , CONSTRAINT BK_BOOK_AUTHOR_TP1 PRIMARY KEY(BOOK_ID,AUTHOR_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_BOOK_T
# -----------------------------------------------------------------------
drop table if exists BK_BOOK_T
/

CREATE TABLE BK_BOOK_T
(
      BOOK_ID DECIMAL(22)
        , TITLE VARCHAR(100)
        , AUTHOR VARCHAR(100)
        , TYP_CD VARCHAR(40)
        , ISBN VARCHAR(17)
        , PUBLISHER VARCHAR(100)
        , PUB_DATE DATETIME
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , PRICE DECIMAL(15,2)
        , RATING DECIMAL(22)
    
    , CONSTRAINT BK_BOOK_TP1 PRIMARY KEY(BOOK_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_BOOK_TYP_T
# -----------------------------------------------------------------------
drop table if exists BK_BOOK_TYP_T
/

CREATE TABLE BK_BOOK_TYP_T
(
      TYP_CD VARCHAR(40)
        , NM VARCHAR(100)
        , DESC_TXT VARCHAR(255)
        , ACTV_IND VARCHAR(1) default 'Y'
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_BOOK_TYP_TP1 PRIMARY KEY(TYP_CD)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_ORDER_DOC_T
# -----------------------------------------------------------------------
drop table if exists BK_ORDER_DOC_T
/

CREATE TABLE BK_ORDER_DOC_T
(
      DOC_HDR_ID DECIMAL(22)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_ORDER_DOC_TP1 PRIMARY KEY(DOC_HDR_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_ORDER_ENTRY_T
# -----------------------------------------------------------------------
drop table if exists BK_ORDER_ENTRY_T
/

CREATE TABLE BK_ORDER_ENTRY_T
(
      BK_ORDER_ENTRY_ID DECIMAL(22)
        , DOC_HDR_ID VARCHAR(14) NOT NULL
        , BOOK_ID DECIMAL(22) NOT NULL
        , QUANTITY DECIMAL(22) NOT NULL
        , UNIT_PRICE DECIMAL(15,2)
        , DISCOUNT DECIMAL(5,2)
        , TOTAL_PRICE DECIMAL(15,2)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT BK_ORDER_ENTRY_TP1 PRIMARY KEY(BK_ORDER_ENTRY_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRAD_MSG_T
# -----------------------------------------------------------------------
drop table if exists KRAD_MSG_T
/

CREATE TABLE KRAD_MSG_T
(
      NMSPC_CD VARCHAR(20)
        , CMPNT_CD VARCHAR(100)
        , MSG_KEY VARCHAR(100)
        , LOC VARCHAR(80)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , MSG_DESC VARCHAR(255)
        , TXT VARCHAR(4000)
    
    , CONSTRAINT KRAD_MSG_TP1 PRIMARY KEY(NMSPC_CD,CMPNT_CD,MSG_KEY,LOC)

    , CONSTRAINT KRAD_MSG_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_ADHOC_RTE_ACTN_RECIP_T
# -----------------------------------------------------------------------
drop table if exists KRNS_ADHOC_RTE_ACTN_RECIP_T
/

CREATE TABLE KRNS_ADHOC_RTE_ACTN_RECIP_T
(
      RECIP_TYP_CD DECIMAL(1)
        , ACTN_RQST_CD VARCHAR(30)
        , ACTN_RQST_RECIP_ID VARCHAR(70)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , DOC_HDR_ID VARCHAR(14)
    
    , CONSTRAINT KRNS_ADHOC_RTE_ACTN_RECIP_TP1 PRIMARY KEY(RECIP_TYP_CD,ACTN_RQST_CD,ACTN_RQST_RECIP_ID,DOC_HDR_ID)

    , CONSTRAINT KRNS_ADHOC_RTE_ACTN_RECIP_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                                                
                                    
, INDEX KRNS_ADHOC_RTE_ACTN_RECIP_T2 (DOC_HDR_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_ATT_CNTNT_T
# -----------------------------------------------------------------------
drop table if exists KRNS_ATT_CNTNT_T
/

CREATE TABLE KRNS_ATT_CNTNT_T
(
      ATT_ID VARCHAR(36)
        , ATT_CNTNT LONGBLOB
    






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_ATT_T
# -----------------------------------------------------------------------
drop table if exists KRNS_ATT_T
/

CREATE TABLE KRNS_ATT_T
(
      NTE_ID DECIMAL(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , MIME_TYP VARCHAR(255)
        , FILE_NM VARCHAR(250)
        , ATT_ID VARCHAR(36)
        , FILE_SZ DECIMAL(14)
        , ATT_TYP_CD VARCHAR(40)
    
    , CONSTRAINT KRNS_ATT_TP1 PRIMARY KEY(NTE_ID)

    , CONSTRAINT KRNS_ATT_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_DOC_HDR_T
# -----------------------------------------------------------------------
drop table if exists KRNS_DOC_HDR_T
/

CREATE TABLE KRNS_DOC_HDR_T
(
      DOC_HDR_ID VARCHAR(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , FDOC_DESC VARCHAR(255)
        , ORG_DOC_HDR_ID VARCHAR(10)
        , TMPL_DOC_HDR_ID VARCHAR(14)
        , EXPLANATION VARCHAR(400)
    
    , CONSTRAINT KRNS_DOC_HDR_TP1 PRIMARY KEY(DOC_HDR_ID)

    , CONSTRAINT KRNS_DOC_HDR_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                                                                    
                                    
, INDEX KRNS_DOC_HDR_TI3 (ORG_DOC_HDR_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_LOOKUP_RSLT_T
# -----------------------------------------------------------------------
drop table if exists KRNS_LOOKUP_RSLT_T
/

CREATE TABLE KRNS_LOOKUP_RSLT_T
(
      LOOKUP_RSLT_ID VARCHAR(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , PRNCPL_ID VARCHAR(40) NOT NULL
        , LOOKUP_DT DATETIME NOT NULL
        , SERIALZD_RSLTS LONGTEXT
    
    , CONSTRAINT KRNS_LOOKUP_RSLT_TP1 PRIMARY KEY(LOOKUP_RSLT_ID)

    , CONSTRAINT KRNS_LOOKUP_RSLT_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_LOOKUP_SEL_T
# -----------------------------------------------------------------------
drop table if exists KRNS_LOOKUP_SEL_T
/

CREATE TABLE KRNS_LOOKUP_SEL_T
(
      LOOKUP_RSLT_ID VARCHAR(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , PRNCPL_ID VARCHAR(40) NOT NULL
        , LOOKUP_DT DATETIME NOT NULL
        , SEL_OBJ_IDS LONGTEXT
    
    , CONSTRAINT KRNS_LOOKUP_SEL_TP1 PRIMARY KEY(LOOKUP_RSLT_ID)

    , CONSTRAINT KRNS_LOOKUP_SEL_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_MAINT_DOC_ATT_LST_T
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_DOC_ATT_LST_T
/

CREATE TABLE KRNS_MAINT_DOC_ATT_LST_T
(
      ATT_ID VARCHAR(40)
        , DOC_HDR_ID VARCHAR(14) NOT NULL
        , ATT_CNTNT LONGBLOB NOT NULL
        , FILE_NM VARCHAR(150)
        , CNTNT_TYP VARCHAR(255)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 0 NOT NULL
    
    , CONSTRAINT KRNS_MAINT_DOC_ATT_LST_TP1 PRIMARY KEY(ATT_ID)

    , CONSTRAINT KRNS_MAINT_DOC_ATT_LST_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                                                                    
                                    
, INDEX KRNS_MAINT_DOC_ATT_LST_TI1 (DOC_HDR_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_MAINT_DOC_ATT_T
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_DOC_ATT_T
/

CREATE TABLE KRNS_MAINT_DOC_ATT_T
(
      DOC_HDR_ID VARCHAR(14)
        , ATT_CNTNT LONGBLOB NOT NULL
        , FILE_NM VARCHAR(150)
        , CNTNT_TYP VARCHAR(255)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT KRNS_MAINT_DOC_ATT_TP1 PRIMARY KEY(DOC_HDR_ID)

    , CONSTRAINT KRNS_MAINT_DOC_ATT_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_MAINT_DOC_T
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_DOC_T
/

CREATE TABLE KRNS_MAINT_DOC_T
(
      DOC_HDR_ID VARCHAR(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , DOC_CNTNT LONGTEXT
    
    , CONSTRAINT KRNS_MAINT_DOC_TP1 PRIMARY KEY(DOC_HDR_ID)

    , CONSTRAINT KRNS_MAINT_DOC_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_MAINT_LOCK_T
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_LOCK_T
/

CREATE TABLE KRNS_MAINT_LOCK_T
(
      MAINT_LOCK_REP_TXT VARCHAR(500)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , DOC_HDR_ID VARCHAR(14) NOT NULL
        , MAINT_LOCK_ID VARCHAR(14)
    
    , CONSTRAINT KRNS_MAINT_LOCK_TP1 PRIMARY KEY(MAINT_LOCK_ID)

    , CONSTRAINT KRNS_MAINT_LOCK_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                            
                                    
, INDEX KRNS_MAINT_LOCK_TI2 (DOC_HDR_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_NTE_T
# -----------------------------------------------------------------------
drop table if exists KRNS_NTE_T
/

CREATE TABLE KRNS_NTE_T
(
      NTE_ID DECIMAL(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , RMT_OBJ_ID VARCHAR(36) NOT NULL
        , AUTH_PRNCPL_ID VARCHAR(40) NOT NULL
        , POST_TS DATETIME NOT NULL
        , NTE_TYP_CD VARCHAR(4) NOT NULL
        , TXT VARCHAR(800)
        , PRG_CD VARCHAR(1)
        , TPC_TXT VARCHAR(40)
    
    , CONSTRAINT KRNS_NTE_TP1 PRIMARY KEY(NTE_ID)

    , CONSTRAINT KRNS_NTE_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                                                                                                                                
                                    
, INDEX KRNS_NTE_TI1 (RMT_OBJ_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_NTE_TYP_T
# -----------------------------------------------------------------------
drop table if exists KRNS_NTE_TYP_T
/

CREATE TABLE KRNS_NTE_TYP_T
(
      NTE_TYP_CD VARCHAR(4)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , TYP_DESC_TXT VARCHAR(100)
        , ACTV_IND VARCHAR(1)
    
    , CONSTRAINT KRNS_NTE_TYP_TP1 PRIMARY KEY(NTE_TYP_CD)

    , CONSTRAINT KRNS_NTE_TYP_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_PESSIMISTIC_LOCK_T
# -----------------------------------------------------------------------
drop table if exists KRNS_PESSIMISTIC_LOCK_T
/

CREATE TABLE KRNS_PESSIMISTIC_LOCK_T
(
      PESSIMISTIC_LOCK_ID DECIMAL(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , LOCK_DESC_TXT VARCHAR(4000)
        , DOC_HDR_ID VARCHAR(14) NOT NULL
        , GNRT_DT DATETIME NOT NULL
        , PRNCPL_ID VARCHAR(40) NOT NULL
        , SESN_ID VARCHAR(40) default 'undefined' NOT NULL
    
    , CONSTRAINT KRNS_PESSIMISTIC_LOCK_TP1 PRIMARY KEY(PESSIMISTIC_LOCK_ID)

    , CONSTRAINT KRNS_PESSIMISTIC_LOCK_TC0 UNIQUE (OBJ_ID)




    
                                                                                                                                                                                                                                                        
                                    
, INDEX KRNS_PESSIMISTIC_LOCK_TI1 (DOC_HDR_ID )
    
                                                                                                                                                                                                                                                        
                                    
, INDEX KRNS_PESSIMISTIC_LOCK_TI2 (PRNCPL_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRNS_SESN_DOC_T
# -----------------------------------------------------------------------
drop table if exists KRNS_SESN_DOC_T
/

CREATE TABLE KRNS_SESN_DOC_T
(
      SESN_DOC_ID VARCHAR(40)
        , DOC_HDR_ID VARCHAR(14)
        , PRNCPL_ID VARCHAR(40)
        , IP_ADDR VARCHAR(60)
        , SERIALZD_DOC_FRM LONGBLOB
        , LAST_UPDT_DT DATETIME
        , CONTENT_ENCRYPTED_IND CHAR(1) default 'N'
        , OBJ_ID VARCHAR(36)
        , VER_NBR DECIMAL(8) default 0
    
    , CONSTRAINT KRNS_SESN_DOC_TP1 PRIMARY KEY(SESN_DOC_ID,DOC_HDR_ID,PRNCPL_ID,IP_ADDR)





    
                                                                                                                                                                                                                                        
                                    
, INDEX KRNS_SESN_DOC_TI1 (LAST_UPDT_DT )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_BAM_PARM_T
# -----------------------------------------------------------------------
drop table if exists KRSB_BAM_PARM_T
/

CREATE TABLE KRSB_BAM_PARM_T
(
      BAM_PARM_ID DECIMAL(14)
        , BAM_ID DECIMAL(14) NOT NULL
        , PARM LONGTEXT NOT NULL
    
    , CONSTRAINT KRSB_BAM_PARM_TP1 PRIMARY KEY(BAM_PARM_ID)





    
                                                                                                                
                                    
, INDEX KREW_BAM_PARM_TI1 (BAM_ID )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_BAM_T
# -----------------------------------------------------------------------
drop table if exists KRSB_BAM_T
/

CREATE TABLE KRSB_BAM_T
(
      BAM_ID DECIMAL(14)
        , SVC_NM VARCHAR(255) NOT NULL
        , SVC_URL VARCHAR(500) NOT NULL
        , MTHD_NM VARCHAR(2000) NOT NULL
        , THRD_NM VARCHAR(500) NOT NULL
        , CALL_DT DATETIME NOT NULL
        , TGT_TO_STR VARCHAR(2000) NOT NULL
        , SRVR_IND DECIMAL(1) NOT NULL
        , EXCPN_TO_STR VARCHAR(2000)
        , EXCPN_MSG LONGTEXT
    
    , CONSTRAINT KRSB_BAM_TP1 PRIMARY KEY(BAM_ID)





    
                                                                                                                                                                                                                                                                                                
                                    
                                                                                                                                                                                                                                                                                                                    
                                    
, INDEX KRSB_BAM_TI1 (SVC_NM , MTHD_NM (255))
    
                                                                                                                                                                                                                                                                                                
                                    
, INDEX KRSB_BAM_TI2 (SVC_NM )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_MSG_PYLD_T
# -----------------------------------------------------------------------
drop table if exists KRSB_MSG_PYLD_T
/

CREATE TABLE KRSB_MSG_PYLD_T
(
      MSG_QUE_ID DECIMAL(14)
        , MSG_PYLD LONGTEXT NOT NULL
    
    , CONSTRAINT KRSB_MSG_PYLD_TP1 PRIMARY KEY(MSG_QUE_ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_MSG_QUE_T
# -----------------------------------------------------------------------
drop table if exists KRSB_MSG_QUE_T
/

CREATE TABLE KRSB_MSG_QUE_T
(
      MSG_QUE_ID DECIMAL(14)
        , DT DATETIME NOT NULL
        , EXP_DT DATETIME
        , PRIO DECIMAL(8) NOT NULL
        , STAT_CD CHAR(1) NOT NULL
        , RTRY_CNT DECIMAL(8) NOT NULL
        , IP_NBR VARCHAR(2000) NOT NULL
        , SVC_NM VARCHAR(255)
        , APPL_ID VARCHAR(255) NOT NULL
        , SVC_MTHD_NM VARCHAR(2000)
        , APP_VAL_ONE VARCHAR(2000)
        , APP_VAL_TWO VARCHAR(2000)
        , VER_NBR DECIMAL(8) default 0
    
    , CONSTRAINT KRSB_MSG_QUE_TP1 PRIMARY KEY(MSG_QUE_ID)





    
                                                                                                                                                                                                                                                                                                                                                            
                                    
                                                                                                                                                                                                                                                                                                                                                                                
                                    
, INDEX KRSB_MSG_QUE_TI1 (SVC_NM , SVC_MTHD_NM (255))
    
                                                                                                                                                                                                                                                                                                                                                            
                                    
                                                                                                                                                                                                                                                                                                                        
                                    
                                                                                                                                                                                                                                                                                                                                                                                
                                    
                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_MSG_QUE_TI2 (APPL_ID , STAT_CD , IP_NBR (255), DT )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_BLOB_TRIGGERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_BLOB_TRIGGERS
/

CREATE TABLE KRSB_QRTZ_BLOB_TRIGGERS
(
      TRIGGER_NAME VARCHAR(80)
        , TRIGGER_GROUP VARCHAR(80)
        , BLOB_DATA LONGBLOB
    
    , CONSTRAINT KRSB_QRTZ_BLOB_TRIGGERSP1 PRIMARY KEY(TRIGGER_NAME,TRIGGER_GROUP)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_CALENDARS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_CALENDARS
/

CREATE TABLE KRSB_QRTZ_CALENDARS
(
      CALENDAR_NAME VARCHAR(80)
        , CALENDAR LONGBLOB NOT NULL
    
    , CONSTRAINT KRSB_QRTZ_CALENDARSP1 PRIMARY KEY(CALENDAR_NAME)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_CRON_TRIGGERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_CRON_TRIGGERS
/

CREATE TABLE KRSB_QRTZ_CRON_TRIGGERS
(
      TRIGGER_NAME VARCHAR(80)
        , TRIGGER_GROUP VARCHAR(80)
        , CRON_EXPRESSION VARCHAR(80) NOT NULL
        , TIME_ZONE_ID VARCHAR(80)
    
    , CONSTRAINT KRSB_QRTZ_CRON_TRIGGERSP1 PRIMARY KEY(TRIGGER_NAME,TRIGGER_GROUP)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_FIRED_TRIGGERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_FIRED_TRIGGERS
/

CREATE TABLE KRSB_QRTZ_FIRED_TRIGGERS
(
      ENTRY_ID VARCHAR(95)
        , TRIGGER_NAME VARCHAR(80) NOT NULL
        , TRIGGER_GROUP VARCHAR(80) NOT NULL
        , IS_VOLATILE VARCHAR(1) NOT NULL
        , INSTANCE_NAME VARCHAR(80) NOT NULL
        , FIRED_TIME DECIMAL(13) NOT NULL
        , PRIORITY DECIMAL(13) NOT NULL
        , STATE VARCHAR(16) NOT NULL
        , JOB_NAME VARCHAR(80)
        , JOB_GROUP VARCHAR(80)
        , IS_STATEFUL VARCHAR(1)
        , REQUESTS_RECOVERY VARCHAR(1)
    
    , CONSTRAINT KRSB_QRTZ_FIRED_TRIGGERSP1 PRIMARY KEY(ENTRY_ID)





    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI1 (JOB_GROUP )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI2 (JOB_NAME )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI3 (REQUESTS_RECOVERY )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI4 (IS_STATEFUL )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI5 (TRIGGER_GROUP )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI6 (INSTANCE_NAME )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI7 (TRIGGER_NAME )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI8 (TRIGGER_NAME , TRIGGER_GROUP )
    
                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI9 (IS_VOLATILE )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_JOB_DETAILS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_JOB_DETAILS
/

CREATE TABLE KRSB_QRTZ_JOB_DETAILS
(
      JOB_NAME VARCHAR(80)
        , JOB_GROUP VARCHAR(80)
        , DESCRIPTION VARCHAR(120)
        , JOB_CLASS_NAME VARCHAR(128) NOT NULL
        , IS_DURABLE VARCHAR(1) NOT NULL
        , IS_VOLATILE VARCHAR(1) NOT NULL
        , IS_STATEFUL VARCHAR(1) NOT NULL
        , REQUESTS_RECOVERY VARCHAR(1) NOT NULL
        , JOB_DATA LONGBLOB
    
    , CONSTRAINT KRSB_QRTZ_JOB_DETAILSP1 PRIMARY KEY(JOB_NAME,JOB_GROUP)





    
                                                                                                                                                                                                                                                                            
                                    
, INDEX KRSB_QRTZ_JOB_DETAILS_TI1 (REQUESTS_RECOVERY )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_JOB_LISTENERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_JOB_LISTENERS
/

CREATE TABLE KRSB_QRTZ_JOB_LISTENERS
(
      JOB_NAME VARCHAR(80)
        , JOB_GROUP VARCHAR(80)
        , JOB_LISTENER VARCHAR(80)
    
    , CONSTRAINT KRSB_QRTZ_JOB_LISTENERSP1 PRIMARY KEY(JOB_NAME,JOB_GROUP,JOB_LISTENER)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_LOCKS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_LOCKS
/

CREATE TABLE KRSB_QRTZ_LOCKS
(
      LOCK_NAME VARCHAR(40)
    
    , CONSTRAINT KRSB_QRTZ_LOCKSP1 PRIMARY KEY(LOCK_NAME)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_PAUSED_TRIGGER_GRPS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_PAUSED_TRIGGER_GRPS
/

CREATE TABLE KRSB_QRTZ_PAUSED_TRIGGER_GRPS
(
      TRIGGER_GROUP VARCHAR(80)
    
    , CONSTRAINT KRSB_QRTZ_PAUSED_TRIGGER_GRP1 PRIMARY KEY(TRIGGER_GROUP)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_SCHEDULER_STATE
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_SCHEDULER_STATE
/

CREATE TABLE KRSB_QRTZ_SCHEDULER_STATE
(
      INSTANCE_NAME VARCHAR(80)
        , LAST_CHECKIN_TIME DECIMAL(13) NOT NULL
        , CHECKIN_INTERVAL DECIMAL(13) NOT NULL
    
    , CONSTRAINT KRSB_QRTZ_SCHEDULER_STATEP1 PRIMARY KEY(INSTANCE_NAME)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_SIMPLE_TRIGGERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_SIMPLE_TRIGGERS
/

CREATE TABLE KRSB_QRTZ_SIMPLE_TRIGGERS
(
      TRIGGER_NAME VARCHAR(80)
        , TRIGGER_GROUP VARCHAR(80)
        , REPEAT_COUNT DECIMAL(7) NOT NULL
        , REPEAT_INTERVAL DECIMAL(12) NOT NULL
        , TIMES_TRIGGERED DECIMAL(7) NOT NULL
    
    , CONSTRAINT KRSB_QRTZ_SIMPLE_TRIGGERSP1 PRIMARY KEY(TRIGGER_NAME,TRIGGER_GROUP)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_TRIGGERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_TRIGGERS
/

CREATE TABLE KRSB_QRTZ_TRIGGERS
(
      TRIGGER_NAME VARCHAR(80)
        , TRIGGER_GROUP VARCHAR(80)
        , JOB_NAME VARCHAR(80) NOT NULL
        , JOB_GROUP VARCHAR(80) NOT NULL
        , IS_VOLATILE VARCHAR(1) NOT NULL
        , DESCRIPTION VARCHAR(120)
        , NEXT_FIRE_TIME DECIMAL(13)
        , PREV_FIRE_TIME DECIMAL(13)
        , PRIORITY DECIMAL(13)
        , TRIGGER_STATE VARCHAR(16) NOT NULL
        , TRIGGER_TYPE VARCHAR(8) NOT NULL
        , START_TIME DECIMAL(13) NOT NULL
        , END_TIME DECIMAL(13)
        , CALENDAR_NAME VARCHAR(80)
        , MISFIRE_INSTR DECIMAL(2)
        , JOB_DATA LONGBLOB
    
    , CONSTRAINT KRSB_QRTZ_TRIGGERSP1 PRIMARY KEY(TRIGGER_NAME,TRIGGER_GROUP)





    
                                                                                                                                                                                                                                                                                                                                                                                    
                                    
, INDEX KRSB_QRTZ_TRIGGERS_TI1 (NEXT_FIRE_TIME )
    
                                                                                                                                                                                                                                                                                                                                                                                    
                                    
                                                                                                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_TRIGGERS_TI2 (NEXT_FIRE_TIME , TRIGGER_STATE )
    
                                                                                                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_TRIGGERS_TI3 (TRIGGER_STATE )
    
                                                                                                                                                                                                                                                                                                                                                                                                                        
                                    
, INDEX KRSB_QRTZ_TRIGGERS_TI4 (IS_VOLATILE )

) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# KRSB_QRTZ_TRIGGER_LISTENERS
# -----------------------------------------------------------------------
drop table if exists KRSB_QRTZ_TRIGGER_LISTENERS
/

CREATE TABLE KRSB_QRTZ_TRIGGER_LISTENERS
(
      TRIGGER_NAME VARCHAR(80)
        , TRIGGER_GROUP VARCHAR(80)
        , TRIGGER_LISTENER VARCHAR(80)
    
    , CONSTRAINT KRSB_QRTZ_TRIGGER_LISTENERSP1 PRIMARY KEY(TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRAV_DOC_2_ACCOUNTS
# -----------------------------------------------------------------------
drop table if exists TRAV_DOC_2_ACCOUNTS
/

CREATE TABLE TRAV_DOC_2_ACCOUNTS
(
      FDOC_NBR VARCHAR(14)
        , ACCT_NUM VARCHAR(10)
    
    , CONSTRAINT TRAV_DOC_2_ACCOUNTSP1 PRIMARY KEY(FDOC_NBR,ACCT_NUM)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_AUTH_DOC_T
# -----------------------------------------------------------------------
drop table if exists TRVL_AUTH_DOC_T
/

CREATE TABLE TRVL_AUTH_DOC_T
(
      TRVL_AUTH_DOC_ID VARCHAR(40)
        , TRAVELER_DTL_ID VARCHAR(40)
        , TRVL_TYP_CD VARCHAR(3)
        , TRVL_BGN_DT DATETIME
        , TRVL_END_DT DATETIME
        , TRVL_DEST_ID VARCHAR(40)
        , EXP_LMT DECIMAL(19,2) default 0.00
        , TRVL_DESC VARCHAR(255)
        , CELL_PH_NUM VARCHAR(20)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT TRVL_AUTH_DOC_TP1 PRIMARY KEY(TRVL_AUTH_DOC_ID)

    , CONSTRAINT TRVL_AUTH_DOC_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_CO_T
# -----------------------------------------------------------------------
drop table if exists TRVL_CO_T
/

CREATE TABLE TRVL_CO_T
(
      CO_ID VARCHAR(40)
        , CO_NM VARCHAR(40) NOT NULL
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , ACTV_IND VARCHAR(1) default 'Y' NOT NULL
    
    , CONSTRAINT TRVL_CO_TP1 PRIMARY KEY(CO_ID)

    , CONSTRAINT TRVL_CO_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_DEST_T
# -----------------------------------------------------------------------
drop table if exists TRVL_DEST_T
/

CREATE TABLE TRVL_DEST_T
(
      TRVL_DEST_ID VARCHAR(40)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , DEST_NM VARCHAR(40) NOT NULL
        , POSTAL_CNTRY_CD VARCHAR(40) NOT NULL
        , POSTAL_STATE_CD VARCHAR(40) NOT NULL
        , ACTV_IND VARCHAR(1) default 'Y' NOT NULL
    
    , CONSTRAINT TRVL_DEST_TP1 PRIMARY KEY(TRVL_DEST_ID)

    , CONSTRAINT TRVL_DEST_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_EXP_ITM_T
# -----------------------------------------------------------------------
drop table if exists TRVL_EXP_ITM_T
/

CREATE TABLE TRVL_EXP_ITM_T
(
      EXP_ITM_ID VARCHAR(40)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , TRVL_AUTH_DOC_ID VARCHAR(40) NOT NULL
        , TRVL_CO_NM VARCHAR(40) NOT NULL
        , EXP_TYP_CD VARCHAR(40) NOT NULL
        , EXP_AMT DECIMAL(19,2) NOT NULL
        , EXP_DESC VARCHAR(255) NOT NULL
        , EXP_DT DATETIME
        , EXP_REIMB VARCHAR(1) default 'Y'
        , EXP_TXBL VARCHAR(1) default 'Y'
    
    , CONSTRAINT TRVL_EXP_ITM_TP1 PRIMARY KEY(EXP_ITM_ID)

    , CONSTRAINT TRVL_EXP_ITEM_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_MLG_RT_T
# -----------------------------------------------------------------------
drop table if exists TRVL_MLG_RT_T
/

CREATE TABLE TRVL_MLG_RT_T
(
      MLG_RT_ID VARCHAR(40)
        , MLG_RT_CD VARCHAR(40) NOT NULL
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , MLG_RT_NM VARCHAR(40) NOT NULL
        , MLG_RT DECIMAL(7,3) NOT NULL
        , ACTV_IND VARCHAR(1) default 'Y'
    
    , CONSTRAINT TRVL_MLG_RT_TP1 PRIMARY KEY(MLG_RT_ID)

    , CONSTRAINT TRVL_MIL_RT_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_PD_EXP_T
# -----------------------------------------------------------------------
drop table if exists TRVL_PD_EXP_T
/

CREATE TABLE TRVL_PD_EXP_T
(
      PD_EXP_ID VARCHAR(40)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , TRVL_DEST_ID VARCHAR(40) NOT NULL
        , TRVL_AUTH_DOC_ID VARCHAR(40) NOT NULL
        , PD_DT DATETIME
        , BKFST_VAL DECIMAL(19,2) NOT NULL
        , LNCH_VAL DECIMAL(19,2) NOT NULL
        , DNNR_VAL DECIMAL(19,2) NOT NULL
        , INCD_VAL DECIMAL(19,2) NOT NULL
        , MLG_RT_ID VARCHAR(40) NOT NULL
        , MLG_EST DECIMAL(8) NOT NULL
    
    , CONSTRAINT TRVL_PD_EXP_TP1 PRIMARY KEY(PD_EXP_ID)

    , CONSTRAINT TRVL_PD_EXP_TC1 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_TRAVELER_DTL_T
# -----------------------------------------------------------------------
drop table if exists TRVL_TRAVELER_DTL_T
/

CREATE TABLE TRVL_TRAVELER_DTL_T
(
      ID VARCHAR(40)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , ACTV_IND VARCHAR(1) default 'Y'
        , CITIZENSHIP VARCHAR(40)
        , CITY_NM VARCHAR(50)
        , COUNTRY_CD VARCHAR(2)
        , CUSTOMER_NUM VARCHAR(40)
        , DOC_NBR VARCHAR(14)
        , DRIVE_LIC_EXP_DT DATETIME
        , DRIVE_LIC_NUM VARCHAR(20)
        , EMAIL_ADDR VARCHAR(50)
        , FIRST_NM VARCHAR(40)
        , GENDER VARCHAR(1)
        , LAST_NM VARCHAR(40)
        , MIDDLENAME VARCHAR(40)
        , NON_RES_ALIEN VARCHAR(1)
        , PHONE_NBR VARCHAR(20)
        , EMP_PRINCIPAL_ID VARCHAR(255)
        , POSTAL_STATE_CD VARCHAR(2)
        , ADDR_LINE_1 VARCHAR(50)
        , ADDR_LINE_2 VARCHAR(50)
        , TRAVELER_TYP_CD VARCHAR(3)
        , POSTAL_CD VARCHAR(11)
    
    , CONSTRAINT TRVL_TRAVELER_DTL_TP1 PRIMARY KEY(ID)

    , CONSTRAINT TRVL_TRAVELER_DTL_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRVL_TRAVELER_TYP_T
# -----------------------------------------------------------------------
drop table if exists TRVL_TRAVELER_TYP_T
/

CREATE TABLE TRVL_TRAVELER_TYP_T
(
      CODE VARCHAR(45)
        , SRC_CODE VARCHAR(45)
        , NM VARCHAR(45)
        , ADVANCES_IND VARCHAR(45)
        , ACTV_IND VARCHAR(45)
        , OBJ_ID VARCHAR(45)
        , VER_NBR DECIMAL
    
    , CONSTRAINT TRVL_TRAVELER_TYP_TP1 PRIMARY KEY(CODE)

    , CONSTRAINT TRVL_TRAVELER_TYP_T_TC0 UNIQUE (OBJ_ID)





) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ACCT
# -----------------------------------------------------------------------
drop table if exists TRV_ACCT
/

CREATE TABLE TRV_ACCT
(
      ACCT_NUM VARCHAR(10)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , ACCT_NAME VARCHAR(40)
        , ACCT_TYPE VARCHAR(3)
        , ACCT_FO_ID VARCHAR(40)
        , CREATE_DT DATETIME
        , SUBSIDIZED_PCT DECIMAL(5,2)
    
    , CONSTRAINT TRV_ACCTP1 PRIMARY KEY(ACCT_NUM)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ACCT_EXT
# -----------------------------------------------------------------------
drop table if exists TRV_ACCT_EXT
/

CREATE TABLE TRV_ACCT_EXT
(
      ACCT_NUM VARCHAR(10)
        , ACCT_TYPE VARCHAR(100)
        , OBJ_ID VARCHAR(36)
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT TRV_ACCT_EXTP1 PRIMARY KEY(ACCT_NUM,ACCT_TYPE)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ACCT_TYPE
# -----------------------------------------------------------------------
drop table if exists TRV_ACCT_TYPE
/

CREATE TABLE TRV_ACCT_TYPE
(
      ACCT_TYPE VARCHAR(3)
        , ACCT_TYPE_NAME VARCHAR(40)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , ACTV_IND VARCHAR(1)
    
    , CONSTRAINT TRV_ACCT_TYPEP1 PRIMARY KEY(ACCT_TYPE)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ACCT_USE_RT_T
# -----------------------------------------------------------------------
drop table if exists TRV_ACCT_USE_RT_T
/

CREATE TABLE TRV_ACCT_USE_RT_T
(
      ID VARCHAR(40)
        , ACCT_NUM VARCHAR(10)
        , RATE DECIMAL(8)
        , ACTV_FRM_DT DATETIME
        , ACTV_TO_DT DATETIME
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
    
    , CONSTRAINT TRV_ACCT_USE_RT_TP1 PRIMARY KEY(ID)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ATT_GRP_SAMPLE
# -----------------------------------------------------------------------
drop table if exists TRV_ATT_GRP_SAMPLE
/

CREATE TABLE TRV_ATT_GRP_SAMPLE
(
      ATT_GRP_NUM VARCHAR(10)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , ATT_GRP_NAME VARCHAR(40)
    
    , CONSTRAINT TRV_ATT_GRP_SAMPLEP1 PRIMARY KEY(ATT_GRP_NUM)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_ATT_SAMPLE
# -----------------------------------------------------------------------
drop table if exists TRV_ATT_SAMPLE
/

CREATE TABLE TRV_ATT_SAMPLE
(
      ATTACHMENT_ID VARCHAR(30)
        , ATT_GRP_NUM VARCHAR(30)
        , DESCRIPTION VARCHAR(4000)
        , ATTACHMENT_FILENAME VARCHAR(300)
        , ATTACHMENT_FILE_CONTENT_TYPE VARCHAR(255)
        , ATTACHMENT_FILE LONGBLOB
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 0 NOT NULL
    
    , CONSTRAINT TRV_ATT_SAMPLEP1 PRIMARY KEY(ATTACHMENT_ID,ATT_GRP_NUM)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_DOC_2
# -----------------------------------------------------------------------
drop table if exists TRV_DOC_2
/

CREATE TABLE TRV_DOC_2
(
      FDOC_NBR VARCHAR(14)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , FDOC_EXPLAIN_TXT VARCHAR(400)
        , REQUEST_TRAV VARCHAR(30) NOT NULL
        , TRAVELER VARCHAR(200)
        , ORG VARCHAR(60)
        , DEST VARCHAR(60)
    
    , CONSTRAINT TRV_DOC_2P1 PRIMARY KEY(FDOC_NBR)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_DOC_ACCT
# -----------------------------------------------------------------------
drop table if exists TRV_DOC_ACCT
/

CREATE TABLE TRV_DOC_ACCT
(
      DOC_HDR_ID VARCHAR(40)
        , ACCT_NUM VARCHAR(10)
    
    , CONSTRAINT TRV_DOC_ACCTP1 PRIMARY KEY(DOC_HDR_ID,ACCT_NUM)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# TRV_SUB_ACCT
# -----------------------------------------------------------------------
drop table if exists TRV_SUB_ACCT
/

CREATE TABLE TRV_SUB_ACCT
(
      ACCT_NUM VARCHAR(10)
        , SUB_ACCT VARCHAR(10)
        , OBJ_ID VARCHAR(36) NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , SUB_ACCT_NAME VARCHAR(40)
    
    , CONSTRAINT TRV_SUB_ACCTP1 PRIMARY KEY(ACCT_NUM,SUB_ACCT)






) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


# -----------------------------------------------------------------------
# BK_ADDRESS_ID_S
# -----------------------------------------------------------------------
drop table if exists BK_ADDRESS_ID_S
/

CREATE TABLE BK_ADDRESS_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE BK_ADDRESS_ID_S auto_increment = 1
/

# -----------------------------------------------------------------------
# BK_AUTHOR_ID_S
# -----------------------------------------------------------------------
drop table if exists BK_AUTHOR_ID_S
/

CREATE TABLE BK_AUTHOR_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE BK_AUTHOR_ID_S auto_increment = 1
/

# -----------------------------------------------------------------------
# BK_BOOK_ID_S
# -----------------------------------------------------------------------
drop table if exists BK_BOOK_ID_S
/

CREATE TABLE BK_BOOK_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE BK_BOOK_ID_S auto_increment = 1
/

# -----------------------------------------------------------------------
# BK_ORDER_ENTRY_S
# -----------------------------------------------------------------------
drop table if exists BK_ORDER_ENTRY_S
/

CREATE TABLE BK_ORDER_ENTRY_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE BK_ORDER_ENTRY_S auto_increment = 1
/

# -----------------------------------------------------------------------
# KRNS_DOC_TYP_ATTR_S
# -----------------------------------------------------------------------
drop table if exists KRNS_DOC_TYP_ATTR_S
/

CREATE TABLE KRNS_DOC_TYP_ATTR_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_DOC_TYP_ATTR_S auto_increment = 1000
/

# -----------------------------------------------------------------------
# KRNS_LOCK_S
# -----------------------------------------------------------------------
drop table if exists KRNS_LOCK_S
/

CREATE TABLE KRNS_LOCK_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_LOCK_S auto_increment = 2000
/

# -----------------------------------------------------------------------
# KRNS_LOOKUP_RSLT_S
# -----------------------------------------------------------------------
drop table if exists KRNS_LOOKUP_RSLT_S
/

CREATE TABLE KRNS_LOOKUP_RSLT_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_LOOKUP_RSLT_S auto_increment = 2000
/

# -----------------------------------------------------------------------
# KRNS_MAINT_DOC_ATT_S
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_DOC_ATT_S
/

CREATE TABLE KRNS_MAINT_DOC_ATT_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_MAINT_DOC_ATT_S auto_increment = 10000
/

# -----------------------------------------------------------------------
# KRNS_MAINT_LOCK_S
# -----------------------------------------------------------------------
drop table if exists KRNS_MAINT_LOCK_S
/

CREATE TABLE KRNS_MAINT_LOCK_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_MAINT_LOCK_S auto_increment = 2020
/

# -----------------------------------------------------------------------
# KRNS_NTE_S
# -----------------------------------------------------------------------
drop table if exists KRNS_NTE_S
/

CREATE TABLE KRNS_NTE_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRNS_NTE_S auto_increment = 2020
/

# -----------------------------------------------------------------------
# KRSB_BAM_PARM_S
# -----------------------------------------------------------------------
drop table if exists KRSB_BAM_PARM_S
/

CREATE TABLE KRSB_BAM_PARM_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRSB_BAM_PARM_S auto_increment = 2000
/

# -----------------------------------------------------------------------
# KRSB_BAM_S
# -----------------------------------------------------------------------
drop table if exists KRSB_BAM_S
/

CREATE TABLE KRSB_BAM_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRSB_BAM_S auto_increment = 2000
/

# -----------------------------------------------------------------------
# KRSB_MSG_QUE_S
# -----------------------------------------------------------------------
drop table if exists KRSB_MSG_QUE_S
/

CREATE TABLE KRSB_MSG_QUE_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE KRSB_MSG_QUE_S auto_increment = 467
/

# -----------------------------------------------------------------------
# TRVL_CO_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_CO_ID_S
/

CREATE TABLE TRVL_CO_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_CO_ID_S auto_increment = 10021
/

# -----------------------------------------------------------------------
# TRVL_DEST_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_DEST_ID_S
/

CREATE TABLE TRVL_DEST_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_DEST_ID_S auto_increment = 10001
/

# -----------------------------------------------------------------------
# TRVL_EXP_ITM_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_EXP_ITM_ID_S
/

CREATE TABLE TRVL_EXP_ITM_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_EXP_ITM_ID_S auto_increment = 10001
/

# -----------------------------------------------------------------------
# TRVL_ID_SEQ
# -----------------------------------------------------------------------
drop table if exists TRVL_ID_SEQ
/

CREATE TABLE TRVL_ID_SEQ
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_ID_SEQ auto_increment = 1
/

# -----------------------------------------------------------------------
# TRVL_MLG_RT_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_MLG_RT_ID_S
/

CREATE TABLE TRVL_MLG_RT_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_MLG_RT_ID_S auto_increment = 10001
/

# -----------------------------------------------------------------------
# TRVL_PD_EXP_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_PD_EXP_ID_S
/

CREATE TABLE TRVL_PD_EXP_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_PD_EXP_ID_S auto_increment = 10001
/

# -----------------------------------------------------------------------
# TRVL_TRAVELER_DTL_ID_S
# -----------------------------------------------------------------------
drop table if exists TRVL_TRAVELER_DTL_ID_S
/

CREATE TABLE TRVL_TRAVELER_DTL_ID_S
(
	id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM
/
ALTER TABLE TRVL_TRAVELER_DTL_ID_S auto_increment = 10001
/
