/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.MessageDelivererRegistryService;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class RecipientPreferenceServiceTest
extends KCBTestCase {
    public static final String VALID_DELIVERER_NAME = "Email";
    public static final String VALID_PROPERTY = "Email.email_address";
    public static final String VALID_VALUE = "kuali-kcb-testing@localhost.edu";
    public static final String VALID_USER_ID = "user1";

    @Test
    public void saveRecipientPreferences() throws ErrorList {
        RecipientPreferenceService impl = this.services.getRecipientPreferenceService();
        MessageDelivererRegistryService delivererService = this.services.getMessageDelivererRegistryService();
        MessageDeliverer deliverer = delivererService.getDelivererByName(VALID_DELIVERER_NAME);
        if (deliverer == null) {
            throw new RuntimeException("Message deliverer could not be obtained");
        }
        HashMap<String, String> userprefs = new HashMap<String, String>();
        userprefs.put(VALID_PROPERTY, VALID_VALUE);
        userprefs.put("Email.email_delivery_format", "text");
        impl.saveRecipientPreferences(VALID_USER_ID, userprefs, deliverer);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)VALID_USER_ID)});
        List prefs = KRADServiceLocator.getDataObjectService().findMatching(RecipientPreference.class, criteria.build()).getResults();
        Assert.assertEquals((long)2L, (long)prefs.size());
    }
}

