/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.kcb.test.KCBTestData;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.dao.DataAccessException;

public class RecipientPreferenceTest
extends KCBTestCase {
    private RecipientPreference PREF;
    private RecipientPreferenceService prefsvc;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.prefsvc = GlobalKCBServiceLocator.getInstance().getRecipientPreferenceService();
        this.PREF = new RecipientPreference();
        this.PREF.setRecipientId("user1");
        this.PREF.setProperty("property1");
        this.PREF.setValue("value1");
        this.PREF = this.prefsvc.saveRecipientPreference(this.PREF);
    }

    @Test
    public void testCreate() {
        RecipientPreference p2 = new RecipientPreference();
        p2.setRecipientId("user1");
        p2.setProperty("property2");
        p2.setValue("value2");
        p2 = this.prefsvc.saveRecipientPreference(p2);
        Assert.assertNotNull((Object)p2.getId());
        HashMap p = this.prefsvc.getRecipientPreferences("user1");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertTrue((boolean)p.containsKey("property1"));
        Assert.assertTrue((boolean)p.containsKey("property2"));
    }

    @Test
    public void testDelete() {
        this.prefsvc.deleteRecipientPreference(this.PREF);
        Assert.assertNull((Object)this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty()));
        Assert.assertEquals((long)0L, (long)this.prefsvc.getRecipientPreferences(this.PREF.getRecipientId()).size());
    }

    @Test(expected=DataAccessException.class)
    public void testDuplicateCreate() {
        RecipientPreference p = new RecipientPreference();
        p.setId(KCBTestData.FAKE_ID);
        p.setRecipientId(this.PREF.getRecipientId());
        p.setProperty(this.PREF.getProperty());
        p.setValue(this.PREF.getValue());
        this.prefsvc.saveRecipientPreference(p);
        KRADServiceLocator.getDataObjectService().flush(RecipientPreference.class);
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidCreate() {
        RecipientPreference p = new RecipientPreference();
        this.prefsvc.saveRecipientPreference(p);
        KRADServiceLocator.getDataObjectService().flush(RecipientPreference.class);
    }

    @Test
    public void testInvalidRead() {
        RecipientPreference p = this.prefsvc.getRecipientPreference("nobody", "nuthin'");
        Assert.assertNull((Object)p);
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidUpdate() {
        RecipientPreference sample = new RecipientPreference();
        sample.setRecipientId("user1");
        sample.setProperty("uniqueproperty");
        sample.setValue("value1");
        this.prefsvc.saveRecipientPreference(sample);
        KRADServiceLocator.getDataObjectService().flush(RecipientPreference.class);
        RecipientPreference p1 = this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty());
        p1.setProperty(null);
        this.prefsvc.saveRecipientPreference(p1);
        KRADServiceLocator.getDataObjectService().flush(RecipientPreference.class);
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidUpdateUniqueConstraint() {
        RecipientPreference sample = new RecipientPreference();
        sample.setRecipientId("user1");
        sample.setProperty("uniqueproperty");
        sample.setValue("value1");
        this.prefsvc.saveRecipientPreference(sample);
        RecipientPreference p2 = this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty());
        p2.setProperty("uniqueproperty");
        this.prefsvc.saveRecipientPreference(p2);
        KRADServiceLocator.getDataObjectService().flush(RecipientPreference.class);
    }

    @Test
    public void testReadByQuery() {
        RecipientPreference p = this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty());
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)this.PREF, (Object)p);
    }

    @Test
    public void testUpdate() {
        RecipientPreference p = this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty());
        p.setValue("different value");
        p = this.prefsvc.saveRecipientPreference(p);
        RecipientPreference p2 = this.prefsvc.getRecipientPreference(this.PREF.getRecipientId(), this.PREF.getProperty());
        Assert.assertEquals((Object)p, (Object)p2);
    }
}

