/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.HashMap;
import org.junit.Assert;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;

public class NotificationProducerDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    NotificationChannelBo mockChannel1 = MockObjectsUtil.getTestChannel1();
    NotificationChannelBo mockChannel2 = MockObjectsUtil.getTestChannel2();
    NotificationProducerBo mockProducer1 = MockObjectsUtil.getTestProducer1();
    private String[] updatedDescriptions = new String[]{"Test 1 - updated description", "Test 2 - updated description"};

    @Override
    protected void setup() {
        super.setup();
        this.businessObjectDao.save((Object)this.mockChannel1);
        this.businessObjectDao.save((Object)this.mockChannel2);
    }

    @Override
    protected boolean delete() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        NotificationProducerBo producer4 = new NotificationProducerBo();
        criteria.put("name", this.mockProducer1.getName());
        producer4 = (NotificationProducerBo)this.businessObjectDao.findByUniqueKey(NotificationProducerBo.class, criteria);
        Assert.assertEquals((long)1L, (long)producer4.getChannels().size());
        criteria.clear();
        NotificationProducerBo producer5 = new NotificationProducerBo();
        criteria.put("name", this.mockProducer1.getName());
        producer5 = (NotificationProducerBo)this.businessObjectDao.findByUniqueKey(NotificationProducerBo.class, criteria);
        try {
            this.businessObjectDao.delete((Object)producer5);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        NotificationProducerBo producer2 = new NotificationProducerBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", this.mockProducer1.getName());
        producer2 = (NotificationProducerBo)this.businessObjectDao.findByUniqueKey(NotificationProducerBo.class, criteria);
        boolean success = true;
        success &= producer2 != null;
        success &= producer2.getDescription().equals(this.mockProducer1.getDescription());
        return success &= producer2.getChannels().size() == 2;
    }

    @Override
    protected boolean insert() {
        NotificationProducerBo producer1 = MockObjectsUtil.getTestProducer1();
        producer1.getChannels().add(this.mockChannel1);
        producer1.getChannels().add(this.mockChannel2);
        try {
            this.businessObjectDao.save((Object)producer1);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean update() {
        NotificationProducerBo producer2 = new NotificationProducerBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", this.mockProducer1.getName());
        producer2 = (NotificationProducerBo)this.businessObjectDao.findByUniqueKey(NotificationProducerBo.class, criteria);
        producer2.setDescription(this.updatedDescriptions[0]);
        producer2.getChannels().remove(0);
        try {
            this.businessObjectDao.save((Object)producer2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        NotificationProducerBo producer2 = new NotificationProducerBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", this.mockProducer1.getName());
        producer2 = (NotificationProducerBo)this.businessObjectDao.findByUniqueKey(NotificationProducerBo.class, criteria);
        boolean success = true;
        success &= producer2.getDescription().equals(this.updatedDescriptions[0]);
        return success &= producer2.getChannels().size() == 1;
    }
}

