/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.HashMap;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;

public class UserChannelSubscriptionDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    NotificationChannelBo channel1 = MockObjectsUtil.getTestChannel1();
    NotificationChannelBo channel2 = MockObjectsUtil.getTestChannel2();
    UserChannelSubscriptionBo subscription1 = new UserChannelSubscriptionBo();
    UserChannelSubscriptionBo subscription2 = new UserChannelSubscriptionBo();
    private String[] userIds = new String[]{"ag266", "jaf30"};
    private String[] updatedUserIds = new String[]{"bh79", "arh14"};

    @Override
    protected void setup() {
        this.businessObjectDao.save((Object)this.channel1);
        this.businessObjectDao.save((Object)this.channel2);
    }

    @Override
    protected boolean delete() {
        try {
            this.businessObjectDao.delete((Object)this.subscription1);
            this.businessObjectDao.delete((Object)this.subscription2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        this.subscription1 = null;
        this.subscription2 = null;
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("channel.id", this.channel1.getId());
        criteria.put("userId", this.userIds[0]);
        this.subscription1 = (UserChannelSubscriptionBo)this.businessObjectDao.findByUniqueKey(UserChannelSubscriptionBo.class, criteria);
        criteria.clear();
        criteria.put("channel.id", this.channel2.getId());
        criteria.put("userId", this.userIds[1]);
        this.subscription2 = (UserChannelSubscriptionBo)this.businessObjectDao.findByUniqueKey(UserChannelSubscriptionBo.class, criteria);
        boolean success = true;
        success &= this.subscription1 != null;
        success &= this.subscription1.getId() > 0L;
        success &= this.subscription1.getChannel().getId().equals(this.channel1.getId());
        success &= this.subscription2 != null;
        success &= this.subscription2.getId() > 0L;
        return success &= this.subscription2.getChannel().getId().equals(this.channel2.getId());
    }

    @Override
    protected boolean insert() {
        this.subscription1.setChannel(this.channel1);
        this.subscription1.setUserId(this.userIds[0]);
        this.subscription2.setChannel(this.channel2);
        this.subscription2.setUserId(this.userIds[1]);
        try {
            this.businessObjectDao.save((Object)this.subscription1);
            this.businessObjectDao.save((Object)this.subscription2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean update() {
        this.subscription1.setUserId(this.updatedUserIds[0]);
        this.subscription2.setUserId(this.updatedUserIds[1]);
        try {
            this.businessObjectDao.save((Object)this.subscription1);
            this.businessObjectDao.save((Object)this.subscription2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        this.subscription1 = new UserChannelSubscriptionBo();
        this.subscription2 = new UserChannelSubscriptionBo();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("channel.id", this.channel1.getId());
        criteria.put("userId", this.updatedUserIds[0]);
        this.subscription1 = (UserChannelSubscriptionBo)this.businessObjectDao.findByUniqueKey(UserChannelSubscriptionBo.class, criteria);
        criteria.clear();
        criteria.put("channel.id", this.channel2.getId());
        criteria.put("userId", this.updatedUserIds[1]);
        this.subscription2 = (UserChannelSubscriptionBo)this.businessObjectDao.findByUniqueKey(UserChannelSubscriptionBo.class, criteria);
        boolean success = true;
        success &= this.subscription1 != null;
        success &= this.subscription1.getId() > 0L;
        success &= this.subscription1.getChannel().getId().equals(this.channel1.getId());
        success &= this.subscription1.getUserId().equals(this.updatedUserIds[0]);
        success &= this.subscription2 != null;
        success &= this.subscription2.getId() > 0L;
        success &= this.subscription2.getChannel().getId().equals(this.channel2.getId());
        return success &= this.subscription2.getUserId().equals(this.updatedUserIds[1]);
    }
}

