/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.ProcessingResult;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.quartz.SchedulerException;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationServiceImplTest
extends KENTestCase {
    @Test
    public void testGetNotification_validNotification() {
        NotificationService nSvc = this.services.getNotificationService();
        NotificationBo notification = nSvc.getNotification(TestConstants.NOTIFICATION_1);
        Assert.assertNotNull((Object)notification.getContent());
        Assert.assertTrue((boolean)notification.getDeliveryType().equals("FYI"));
    }

    @Test
    public void testGetNotification_nonExistentNotification() {
        NotificationService nSvc = this.services.getNotificationService();
        NotificationBo notification = nSvc.getNotification(TestConstants.NON_EXISTENT_ID);
        Assert.assertNull((Object)notification);
    }

    @Test
    public void testGetNotificationsForRecipientByType_validInput() {
        NotificationService nSvc = this.services.getNotificationService();
        Assert.assertTrue((nSvc.getNotificationsForRecipientByType("Simple", "testuser5").size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNotificationsForRecipientByType_invalidInput() {
        NotificationService nSvc = this.services.getNotificationService();
        Assert.assertTrue((nSvc.getNotificationsForRecipientByType("Bad Type", "testuser5").size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSendNotificationAsXml_validInput() throws InterruptedException, SchedulerException, IOException, XmlException {
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        Thread.sleep(10000L);
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("KualiNotification");
        List list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_before = list.size();
        this.LOG.info((Object)("ActionRequests: " + count_before));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        NotificationService nSvc = this.services.getNotificationService();
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("valid_input.xml"));
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"processingFlag", (Object)"UNRESOLVED")});
        List notifications = KRADServiceLocator.getDataObjectService().findMatching(NotificationBo.class, criteria.build()).getResults();
        Assert.assertEquals((long)0L, (long)notifications.size());
        String[] result = new String[1];
        NotificationResponseBo response = nSvc.sendNotification(notificationMessageAsXml);
        this.LOG.info((Object)("response XML: " + response));
        Assert.assertEquals((Object)"Success", (Object)response.getStatus());
        notifications = KRADServiceLocator.getDataObjectService().findMatching(NotificationBo.class, criteria.build()).getResults();
        Assert.assertEquals((long)1L, (long)notifications.size());
        this.LOG.info((Object)("Notification: " + notifications.iterator().next()));
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_after = list.size();
        this.LOG.info((Object)("ActionRequests before: " + count_before));
        this.LOG.info((Object)("ActionRequests after: " + count_after));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        Assert.assertEquals((long)6L, (long)(count_after - count_before));
    }

    @Test
    public void testSendNotificationAsXml_invalidInput() throws IOException {
        NotificationService nSvc = this.services.getNotificationService();
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("invalid_input.xml"));
        try {
            nSvc.sendNotification(notificationMessageAsXml);
            Assert.fail((String)"XmlException not thrown");
        }
        catch (IOException ioe) {
            Assert.fail((String)("Wrong exception thrown, expected XmlException: " + ioe));
        }
        catch (XmlException ioe) {
        }
        catch (Exception e) {
            Assert.fail((String)("Wrong exception thrown, expected XmlException: " + e));
        }
    }

    @Test
    public void testSendNotificationAsXml_producerNotAuthorized() throws IOException, XmlException {
        NotificationService nSvc = this.services.getNotificationService();
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("producer_not_authorized.xml"));
        NotificationResponseBo response = nSvc.sendNotification(notificationMessageAsXml);
        Assert.assertEquals((Object)"Failure", (Object)response.getStatus());
        Assert.assertEquals((Object)"The notification message was received by the system; however, we cannot process it because the Producer specified cannot send notifications for the Notification Channel specified.", (Object)response.getMessage());
    }

    @Test
    public void testDismiss() throws InterruptedException {
        String action;
        NotificationBo n = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        NotificationMessageDeliveryService nmds = this.services.getNotificationMessageDeliveryService();
        Collection deliveries = nmds.getNotificationMessageDeliveries(n, "testuser5");
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)1L, (long)deliveries.size());
        for (NotificationMessageDelivery delivery : deliveries) {
            Assert.assertEquals((Object)"UNDELIVERED", (Object)delivery.getMessageDeliveryStatus());
        }
        NotificationService nSvc = this.services.getNotificationService();
        ProcessingResult result = this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        deliveries = nmds.getNotificationMessageDeliveries(n, "testuser5");
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)1L, (long)deliveries.size());
        for (NotificationMessageDelivery delivery : deliveries) {
            if (!delivery.getId().equals(TestConstants.BAD_MESSAGE_DELIVERY_ID)) continue;
            Assert.assertEquals((String)("Message Delivery #" + delivery.getId() + "was not delivered"), (Object)"DELIVERED", (Object)delivery.getMessageDeliveryStatus());
        }
        if ("FYI".equals("FYI")) {
            action = "fyi";
        } else if ("ACK".equals("FYI")) {
            action = "ack";
        } else {
            throw new RuntimeException("A new delivery type was defined...this test needs to be updated");
        }
        nSvc.dismissNotificationMessageDelivery(TestConstants.NOT_MSG_DELIV_NOTIF_1_TEST_USER_5, "testuser5", action);
        deliveries = nmds.getNotificationMessageDeliveries(n, "testuser5");
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)1L, (long)deliveries.size());
        for (NotificationMessageDelivery delivery : deliveries) {
            if (delivery.getId() == TestConstants.BAD_MESSAGE_DELIVERY_ID) continue;
            Assert.assertEquals((String)("Message Delivery #" + delivery.getId() + "was not removed"), (Object)"REMOVED", (Object)delivery.getMessageDeliveryStatus());
        }
    }
}

